/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.EmptyTermDocs;
import org.apache.jackrabbit.core.query.lucene.RefCountingIndexReader;
import org.apache.jackrabbit.core.query.lucene.SharedIndexReader;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadOnlyIndexReader
extends RefCountingIndexReader {
    private final SharedIndexReader reader;
    private final BitSet deleted;
    private long deletedDocsVersion;

    public ReadOnlyIndexReader(SharedIndexReader reader, BitSet deleted, long deletedDocsVersion) {
        super((IndexReader)reader);
        this.reader = reader;
        this.deleted = deleted;
        this.deletedDocsVersion = deletedDocsVersion;
        reader.acquire();
    }

    long getDeletedDocsVersion() {
        return this.deletedDocsVersion;
    }

    long getCreationTick() {
        return this.reader.getCreationTick();
    }

    void updateDeletedDocs(CommittableIndexReader reader) {
        int maxDoc = reader.maxDoc();
        for (int i = 0; i < maxDoc; ++i) {
            if (!reader.isDeleted(i)) continue;
            this.deleted.set(i);
        }
        this.deletedDocsVersion = reader.getModificationCount();
    }

    public DocId getParent(int n) throws IOException {
        return this.getBase().getParent(n, this.deleted);
    }

    public SharedIndexReader getBase() {
        return (SharedIndexReader)this.in;
    }

    public boolean isDeleted(int n) {
        return this.deleted.get(n);
    }

    public boolean hasDeletions() {
        return !this.deleted.isEmpty();
    }

    public int numDocs() {
        return this.maxDoc() - this.deleted.cardinality();
    }

    protected final void doDelete(int docNum) {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected final void doUndeleteAll() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    public TermDocs termDocs(Term term) throws IOException {
        Object td = this.reader.termDocs(term);
        if (td != EmptyTermDocs.INSTANCE) {
            td = new FilteredTermDocs((TermDocs)td);
        }
        return td;
    }

    public TermDocs termDocs() throws IOException {
        return new FilteredTermDocs(super.termDocs());
    }

    public TermPositions termPositions() throws IOException {
        return new FilteredTermPositions(super.termPositions());
    }

    private final class FilteredTermPositions
    extends FilteredTermDocs
    implements TermPositions {
        public FilteredTermPositions(TermPositions in) {
            super((TermDocs)in);
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.in).getPayloadLength();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.in).getPayload(data, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.in).isPayloadAvailable();
        }
    }

    private class FilteredTermDocs
    extends FilterIndexReader.FilterTermDocs {
        public FilteredTermDocs(TermDocs in) {
            super(in);
        }

        public final boolean next() throws IOException {
            boolean hasNext = this.in.next();
            while (hasNext && ReadOnlyIndexReader.this.deleted.get(this.in.doc())) {
                hasNext = this.in.next();
            }
            return hasNext;
        }

        public final int read(int[] docs, int[] freqs) throws IOException {
            int numDeleted;
            int num;
            do {
                if ((num = this.in.read(docs, freqs)) == 0) {
                    return 0;
                }
                numDeleted = 0;
                for (int i = 0; i < num; ++i) {
                    if (ReadOnlyIndexReader.this.deleted.get(docs[i])) {
                        ++numDeleted;
                        continue;
                    }
                    if (numDeleted <= 0) continue;
                    docs[i - numDeleted] = docs[i];
                    freqs[i - numDeleted] = freqs[i];
                }
            } while (num == numDeleted);
            return num - numDeleted;
        }

        public final boolean skipTo(int i) throws IOException {
            boolean exists = this.in.skipTo(i);
            while (exists && ReadOnlyIndexReader.this.deleted.get(this.doc())) {
                exists = this.next();
            }
            return exists;
        }
    }
}

