/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.ProtectedItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLEditor
extends ProtectedItemModifier
implements AccessControlEditor,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(ACLEditor.class);
    private static final String DEFAULT_ACE_NAME = "ace";
    private final SessionImpl session;
    private final AccessControlUtils utils;

    ACLEditor(Session editingSession, AccessControlUtils utils) {
        super(64);
        if (!(editingSession instanceof SessionImpl)) {
            throw new IllegalArgumentException("org.apache.jackrabbit.core.SessionImpl expected. Found " + editingSession.getClass());
        }
        this.session = (SessionImpl)editingSession;
        this.utils = utils;
    }

    ACLTemplate getACL(NodeImpl aclNode, String path) throws RepositoryException {
        return new ACLTemplate(aclNode, path);
    }

    public AccessControlPolicy[] getPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        NodeImpl aclNode = this.getAclNode(nodePath);
        if (aclNode == null) {
            return new AccessControlPolicy[0];
        }
        return new AccessControlPolicy[]{this.getACL(aclNode, nodePath)};
    }

    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws AccessControlException, RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Unknown principal.");
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    public AccessControlPolicy[] editAccessControlPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        AccessControlPolicy[] accessControlPolicyArray;
        Name aclName;
        String mixin;
        NodeImpl controlledNode;
        this.checkProtectsNode(nodePath);
        if (nodePath == null) {
            controlledNode = (NodeImpl)this.session.getRootNode();
            mixin = this.session.getJCRName(NT_REP_REPO_ACCESS_CONTROLLABLE);
            aclName = N_REPO_POLICY;
        } else {
            controlledNode = this.getNode(nodePath);
            mixin = this.session.getJCRName(NT_REP_ACCESS_CONTROLLABLE);
            aclName = N_POLICY;
        }
        ACLTemplate acl = null;
        NodeImpl aclNode = this.getAclNode(controlledNode, nodePath);
        if (aclNode == null) {
            if (controlledNode.hasNode(aclName)) {
                log.warn("Colliding policy child without node being access controllable ({}).", (Object)nodePath);
            } else {
                PrivilegeManager privMgr = ((JackrabbitWorkspace)this.session.getWorkspace()).getPrivilegeManager();
                if (controlledNode.isNodeType(mixin) || controlledNode.canAddMixin(mixin)) {
                    acl = new ACLTemplate(nodePath, this.session.getPrincipalManager(), privMgr, this.session.getValueFactory(), this.session);
                } else {
                    log.warn("Node {} cannot be made access controllable.", (Object)nodePath);
                }
            }
        }
        if (acl != null) {
            AccessControlPolicy[] accessControlPolicyArray2 = new AccessControlPolicy[1];
            accessControlPolicyArray = accessControlPolicyArray2;
            accessControlPolicyArray2[0] = acl;
        } else {
            accessControlPolicyArray = new AccessControlPolicy[]{};
        }
        return accessControlPolicyArray;
    }

    public JackrabbitAccessControlPolicy[] editAccessControlPolicies(Principal principal) throws AccessDeniedException, AccessControlException, RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Unknown principal.");
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    public void setPolicy(String nodePath, AccessControlPolicy policy) throws RepositoryException {
        AccessControlEntry[] entries;
        this.checkProtectsNode(nodePath);
        ACLEditor.checkValidPolicy(nodePath, policy);
        NodeImpl aclNode = this.getAclNode(nodePath);
        if (aclNode != null) {
            NodeIterator aceNodes = aclNode.getNodes();
            while (aceNodes.hasNext()) {
                NodeImpl aceNode = (NodeImpl)aceNodes.nextNode();
                this.removeItem(aceNode);
            }
        } else {
            aclNode = nodePath == null ? this.createRepoAclNode() : this.createAclNode(nodePath);
        }
        for (AccessControlEntry entry : entries = ((ACLTemplate)policy).getAccessControlEntries()) {
            AccessControlEntryImpl ace = (AccessControlEntryImpl)entry;
            Name nodeName = ACLEditor.getUniqueNodeName(aclNode, ace.isAllow() ? "allow" : "deny");
            Name ntName = ace.isAllow() ? NT_REP_GRANT_ACE : NT_REP_DENY_ACE;
            ValueFactory vf = this.session.getValueFactory();
            NodeImpl aceNode = this.addNode(aclNode, nodeName, ntName);
            String principalName = ace.getPrincipal().getName();
            this.setProperty(aceNode, P_PRINCIPAL_NAME, vf.createValue(principalName));
            Privilege[] pvlgs = ace.getPrivileges();
            Value[] names = ACLEditor.getPrivilegeNames(pvlgs, vf);
            this.setProperty(aceNode, P_PRIVILEGES, names);
            Set<Name> restrNames = ace.getRestrictions().keySet();
            for (Name restrName : restrNames) {
                Value value = ace.getRestriction(restrName);
                this.setProperty(aceNode, restrName, value);
            }
        }
        this.markModified((NodeImpl)aclNode.getParent());
    }

    public synchronized void removePolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, RepositoryException {
        this.checkProtectsNode(nodePath);
        ACLEditor.checkValidPolicy(nodePath, policy);
        NodeImpl aclNode = this.getAclNode(nodePath);
        if (aclNode == null) {
            throw new AccessControlException("No policy to remove at " + nodePath);
        }
        this.removeItem(aclNode);
    }

    private void checkProtectsNode(String nodePath) throws RepositoryException {
        NodeImpl node;
        if (nodePath != null && this.utils.isAcItem(node = this.getNode(nodePath))) {
            throw new AccessControlException("Node " + nodePath + " defines ACL or ACE itself.");
        }
    }

    private static void checkValidPolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException {
        boolean matchingPath;
        if (policy == null || !(policy instanceof ACLTemplate)) {
            throw new AccessControlException("Attempt to set/remove invalid policy " + policy);
        }
        ACLTemplate acl = (ACLTemplate)policy;
        boolean bl = nodePath == null ? acl.getPath() == null : (matchingPath = nodePath.equals(acl.getPath()));
        if (!matchingPath) {
            throw new AccessControlException("Policy " + policy + " cannot be applied/removed from the node at " + nodePath);
        }
    }

    private NodeImpl getNode(String path) throws PathNotFoundException, RepositoryException {
        return (NodeImpl)this.session.getNode(path);
    }

    private NodeImpl getAclNode(String nodePath) throws PathNotFoundException, RepositoryException {
        NodeImpl controlledNode = nodePath == null ? (NodeImpl)this.session.getRootNode() : this.getNode(nodePath);
        return this.getAclNode(controlledNode, nodePath);
    }

    private NodeImpl getAclNode(NodeImpl controlledNode, String nodePath) throws RepositoryException {
        NodeImpl aclNode = null;
        if (nodePath == null) {
            if (ACLProvider.isRepoAccessControlled(controlledNode)) {
                aclNode = controlledNode.getNode(N_REPO_POLICY);
            }
        } else if (ACLProvider.isAccessControlled(controlledNode)) {
            aclNode = controlledNode.getNode(N_POLICY);
        }
        return aclNode;
    }

    private NodeImpl createAclNode(String nodePath) throws RepositoryException {
        NodeImpl protectedNode = this.getNode(nodePath);
        if (!protectedNode.isNodeType(NT_REP_ACCESS_CONTROLLABLE)) {
            protectedNode.addMixin(NT_REP_ACCESS_CONTROLLABLE);
        }
        return this.addNode(protectedNode, N_POLICY, NT_REP_ACL);
    }

    private NodeImpl createRepoAclNode() throws RepositoryException {
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        if (!root.isNodeType(NT_REP_REPO_ACCESS_CONTROLLABLE)) {
            root.addMixin(NT_REP_REPO_ACCESS_CONTROLLABLE);
        }
        return this.addNode(root, N_REPO_POLICY, NT_REP_ACL);
    }

    protected static Name getUniqueNodeName(Node node, String name) throws RepositoryException {
        if (name == null) {
            name = DEFAULT_ACE_NAME;
        } else {
            try {
                NameParser.checkFormat((String)name);
            }
            catch (NameException e) {
                name = DEFAULT_ACE_NAME;
                log.debug("Invalid path name for Permission: " + name + ".");
            }
        }
        int i = 0;
        String check = name;
        while (node.hasNode(check)) {
            check = name + i;
            ++i;
        }
        return ((SessionImpl)node.getSession()).getQName(check);
    }

    private static Value[] getPrivilegeNames(Privilege[] privileges, ValueFactory valueFactory) throws ValueFormatException {
        Value[] names = new Value[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            names[i] = valueFactory.createValue(privileges[i].getName(), 7);
        }
        return names;
    }
}

