/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.authorization.AbstractACLTemplate;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.GlobPattern;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ACLTemplate
extends AbstractACLTemplate {
    private static final Logger log = LoggerFactory.getLogger(ACLTemplate.class);
    private final List<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
    private final PrincipalManager principalMgr;
    private final PrivilegeManagerImpl privilegeMgr;
    private final NameResolver resolver;
    private final NodeId id;
    private final String jcrRepGlob;

    ACLTemplate(String path, PrincipalManager principalMgr, PrivilegeManager privilegeMgr, ValueFactory valueFactory, NamePathResolver resolver) throws NamespaceException {
        super(path, valueFactory);
        this.principalMgr = principalMgr;
        this.privilegeMgr = (PrivilegeManagerImpl)privilegeMgr;
        this.resolver = resolver;
        this.id = null;
        this.jcrRepGlob = resolver.getJCRName(P_GLOB);
    }

    ACLTemplate(NodeImpl aclNode) throws RepositoryException {
        this(aclNode, aclNode != null ? aclNode.getParent().getPath() : null);
    }

    ACLTemplate(NodeImpl aclNode, String path) throws RepositoryException {
        super(path, aclNode != null ? aclNode.getSession().getValueFactory() : null);
        if (aclNode == null || !NT_REP_ACL.equals(((NodeTypeImpl)aclNode.getPrimaryNodeType()).getQName())) {
            throw new IllegalArgumentException("Node must be of type 'rep:ACL'");
        }
        SessionImpl sImpl = (SessionImpl)aclNode.getSession();
        this.principalMgr = sImpl.getPrincipalManager();
        this.privilegeMgr = (PrivilegeManagerImpl)((JackrabbitWorkspace)sImpl.getWorkspace()).getPrivilegeManager();
        this.resolver = sImpl;
        this.id = aclNode.getParentId();
        this.jcrRepGlob = sImpl.getJCRName(P_GLOB);
        AccessControlManager acMgr = sImpl.getAccessControlManager();
        NodeIterator itr = aclNode.getNodes();
        while (itr.hasNext()) {
            NodeImpl aceNode = (NodeImpl)itr.nextNode();
            try {
                String principalName = aceNode.getProperty(P_PRINCIPAL_NAME).getString();
                Object princ = this.principalMgr.getPrincipal(principalName);
                if (princ == null) {
                    log.debug("Principal with name " + principalName + " unknown to PrincipalManager.");
                    princ = new PrincipalImpl(principalName);
                }
                Value[] privValues = aceNode.getProperty(P_PRIVILEGES).getValues();
                Privilege[] privs = new Privilege[privValues.length];
                for (int i = 0; i < privValues.length; ++i) {
                    privs[i] = acMgr.privilegeFromName(privValues[i].getString());
                }
                Map<String, Value> restrictions = null;
                if (aceNode.hasProperty(P_GLOB)) {
                    restrictions = Collections.singletonMap(this.jcrRepGlob, aceNode.getProperty(P_GLOB).getValue());
                }
                Entry ace = this.createEntry((Principal)princ, privs, NT_REP_GRANT_ACE.equals(((NodeTypeImpl)aceNode.getPrimaryNodeType()).getQName()), restrictions);
                this.entries.add((AccessControlEntry)ace);
            }
            catch (RepositoryException e) {
                log.debug("Failed to build ACE from content.", (Object)e.getMessage());
            }
        }
    }

    Entry createEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws RepositoryException {
        return new Entry(principal, privileges, isAllow, restrictions);
    }

    Entry createEntry(Entry base, Privilege[] newPrivileges, boolean isAllow) throws RepositoryException {
        return new Entry(base, newPrivileges, isAllow);
    }

    private List<Entry> internalGetEntries(Principal principal) {
        String principalName = principal.getName();
        ArrayList<Entry> entriesPerPrincipal = new ArrayList<Entry>(2);
        for (AccessControlEntry entry : this.entries) {
            if (!principalName.equals(entry.getPrincipal().getName())) continue;
            entriesPerPrincipal.add((Entry)entry);
        }
        return entriesPerPrincipal;
    }

    private synchronized boolean internalAdd(Entry entry) throws RepositoryException {
        Principal principal = entry.getPrincipal();
        List<Entry> entriesPerPrincipal = this.internalGetEntries(principal);
        if (entriesPerPrincipal.isEmpty()) {
            this.entries.add((AccessControlEntry)entry);
            return true;
        }
        if (entriesPerPrincipal.contains(entry)) {
            return false;
        }
        int updateIndex = -1;
        AccessControlEntryImpl complementEntry = null;
        for (Entry e : entriesPerPrincipal) {
            if (!this.equalRestriction(entry, e)) continue;
            if (entry.isAllow() == e.isAllow()) {
                if (e.getPrivilegeBits().includes(entry.getPrivilegeBits())) {
                    return false;
                }
                updateIndex = this.entries.indexOf(e);
                this.entries.remove(e);
                PrivilegeBits mergedBits = PrivilegeBits.getInstance(e.getPrivilegeBits());
                mergedBits.add(entry.getPrivilegeBits());
                Set<Privilege> mergedPrivs = this.privilegeMgr.getPrivileges(mergedBits);
                entry = this.createEntry(entry, mergedPrivs.toArray(new Privilege[mergedPrivs.size()]), entry.isAllow());
                continue;
            }
            complementEntry = e;
        }
        if (complementEntry != null) {
            PrivilegeBits complPrivs = complementEntry.getPrivilegeBits();
            PrivilegeBits diff = PrivilegeBits.getInstance(complPrivs);
            diff.diff(entry.getPrivilegeBits());
            if (diff.isEmpty()) {
                this.entries.remove(complementEntry);
                --updateIndex;
            } else if (!diff.equals(complPrivs)) {
                int index = this.entries.indexOf(complementEntry);
                this.entries.remove(complementEntry);
                Set<Privilege> result = this.privilegeMgr.getPrivileges(diff);
                Entry tmpl = this.createEntry(entry, result.toArray(new Privilege[result.size()]), !entry.isAllow());
                this.entries.add(index, (AccessControlEntry)tmpl);
            }
        }
        if (updateIndex < 0) {
            this.entries.add((AccessControlEntry)entry);
        } else {
            this.entries.add(updateIndex, (AccessControlEntry)entry);
        }
        return true;
    }

    private boolean equalRestriction(Entry entry1, Entry entry2) throws RepositoryException {
        Value v1 = entry1.getRestriction(this.jcrRepGlob);
        Value v2 = entry2.getRestriction(this.jcrRepGlob);
        return v1 == null ? v2 == null : v1.equals(v2);
    }

    @Override
    protected void checkValidEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException {
        if (principal instanceof UnknownPrincipal) {
            log.debug("Consider fallback principal as valid: {}", (Object)principal.getName());
        } else if (!this.principalMgr.hasPrincipal(principal.getName())) {
            throw new AccessControlException("Principal " + principal.getName() + " does not exist.");
        }
        if (this.path == null && restrictions != null && !restrictions.isEmpty()) {
            throw new AccessControlException("Repository level policy does not support restrictions.");
        }
    }

    @Override
    protected List<AccessControlEntry> getEntries() {
        return this.entries;
    }

    public synchronized void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!(ace instanceof Entry)) {
            throw new AccessControlException("Invalid AccessControlEntry implementation " + ace.getClass().getName() + ".");
        }
        if (!this.entries.contains(ace)) {
            throw new AccessControlException("AccessControlEntry " + ace + " cannot be removed from ACL defined at " + this.getPath());
        }
        this.entries.remove(ace);
    }

    public String[] getRestrictionNames() {
        String[] stringArray;
        if (this.path == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.jcrRepGlob;
        }
        return stringArray;
    }

    public int getRestrictionType(String restrictionName) {
        if (this.jcrRepGlob.equals(restrictionName) || P_GLOB.toString().equals(restrictionName)) {
            return 1;
        }
        return 0;
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
        this.checkValidEntry(principal, privileges, isAllow, restrictions);
        Entry ace = this.createEntry(principal, privileges, isAllow, restrictions);
        return this.internalAdd(ace);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACLTemplate) {
            ACLTemplate acl = (ACLTemplate)obj;
            return this.path.equals(acl.path) && ((Object)this.entries).equals(acl.entries);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    extends AccessControlEntryImpl {
        private final GlobPattern pattern;

        private Entry(Principal principal, Privilege[] privileges, boolean allow, Map<String, Value> restrictions) throws RepositoryException {
            super(principal, privileges, allow, restrictions);
            this.pattern = this.calculatePattern();
        }

        private Entry(Entry base, Privilege[] newPrivileges, boolean isAllow) throws RepositoryException {
            super(base, newPrivileges, isAllow);
            this.pattern = this.calculatePattern();
        }

        private GlobPattern calculatePattern() throws RepositoryException {
            if (ACLTemplate.this.path == null) {
                return null;
            }
            Value glob = this.getRestrictions().get(AccessControlConstants.P_GLOB);
            GlobPattern p = glob != null ? GlobPattern.create(ACLTemplate.this.path, glob.getString()) : GlobPattern.create(ACLTemplate.this.path);
            return p;
        }

        boolean isLocal(NodeId nodeId) {
            return ACLTemplate.this.id != null && ACLTemplate.this.id.equals(nodeId);
        }

        boolean matches(String jcrPath) {
            return this.pattern != null && this.pattern.matches(jcrPath);
        }

        @Override
        protected NameResolver getResolver() {
            return ACLTemplate.this.resolver;
        }

        @Override
        protected ValueFactory getValueFactory() {
            return ACLTemplate.this.valueFactory;
        }

        @Override
        protected PrivilegeManagerImpl getPrivilegeManager() {
            return ACLTemplate.this.privilegeMgr;
        }
    }
}

