/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachingEntryCollector
extends EntryCollector {
    private static final Logger log = LoggerFactory.getLogger(CachingEntryCollector.class);
    private final Map<NodeId, CacheEntry> cache;
    private final Object monitor = new Object();

    CachingEntryCollector(SessionImpl systemSession, NodeId rootID) throws RepositoryException {
        super(systemSession, rootID);
        this.cache = new GrowingLRUMap(1024, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        super.close();
        Object object = this.monitor;
        synchronized (object) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AccessControlEntry> getEntries(NodeImpl node) throws RepositoryException {
        List<AccessControlEntry> entries;
        NodeId nodeId = node.getNodeId();
        Object object = this.monitor;
        synchronized (object) {
            CacheEntry ce = this.cache.get(nodeId);
            entries = ce != null ? ce.entries : this.updateCache(node);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AccessControlEntry> getEntries(NodeId nodeId) throws RepositoryException {
        List<AccessControlEntry> entries;
        Object object = this.monitor;
        synchronized (object) {
            CacheEntry ce = this.cache.get(nodeId);
            if (ce != null) {
                entries = ce.entries;
            } else {
                NodeImpl n = this.getNodeById(nodeId);
                entries = this.updateCache(n);
            }
        }
        return entries;
    }

    private List<AccessControlEntry> updateCache(NodeImpl node) throws RepositoryException {
        List<AccessControlEntry> entries = super.getEntries(node);
        if (!entries.isEmpty()) {
            NodeId nextId = null;
            NodeImpl n = node;
            while (nextId == null && !this.rootID.equals(n.getNodeId())) {
                if (this.cache.containsKey(n.getNodeId())) {
                    nextId = n.getNodeId();
                    continue;
                }
                if (this.cache.containsKey(n.getParentId())) {
                    nextId = n.getParentId();
                    continue;
                }
                if (!CachingEntryCollector.hasEntries(n = (NodeImpl)n.getParent())) continue;
                nextId = n.getNodeId();
            }
            CacheEntry ce = new CacheEntry(entries, nextId);
            this.cache.put(node.getNodeId(), ce);
            log.debug("Update cache for node with ID {0}: {1}", (Object)node, (Object)ce);
        }
        return entries;
    }

    private static boolean hasEntries(NodeImpl n) throws RepositoryException {
        if (ACLProvider.isAccessControlled(n)) {
            NodeImpl aclNode = n.getNode(N_POLICY);
            return aclNode.hasNodes();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodeId getParentId(NodeId nodeId) throws RepositoryException {
        Object object = this.monitor;
        synchronized (object) {
            CacheEntry ce = this.cache.get(nodeId);
            if (ce != null) {
                return ce.nextAcNodeId;
            }
            return super.getParentId(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners(AccessControlModifications modifications) {
        for (Object key : modifications.getNodeIdentifiers()) {
            if (!(key instanceof NodeId)) {
                log.warn("Cannot process AC modificationMap entry. Keys must be NodeId.");
                continue;
            }
            NodeId nodeId = (NodeId)key;
            int type = modifications.getType(nodeId);
            Object object = this.monitor;
            synchronized (object) {
                if ((type & 1) == 1) {
                    this.cache.clear();
                    break;
                }
                if ((type & 2) == 2) {
                    CacheEntry ce = this.cache.remove(nodeId);
                    if (ce != null) {
                        NodeId nextId = ce.nextAcNodeId;
                        for (CacheEntry entry : this.cache.values()) {
                            if (!nodeId.equals(entry.nextAcNodeId)) continue;
                            entry.nextAcNodeId = nextId;
                        }
                    }
                } else if ((type & 4) == 4) {
                    this.cache.remove(nodeId);
                } else if ((type & 8) == 8) {
                    this.cache.clear();
                    break;
                }
            }
        }
        super.notifyListeners(modifications);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry {
        private final List<AccessControlEntry> entries;
        private NodeId nextAcNodeId;

        private CacheEntry(List<AccessControlEntry> entries, NodeId nextAcNodeId) {
            this.entries = entries;
            this.nextAcNodeId = nextAcNodeId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size = ").append(this.entries.size()).append(", ");
            sb.append("nextAcNodeId = ").append(this.nextAcNodeId);
            return sb.toString();
        }
    }
}

