/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.MembershipCache;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AuthorizableImpl
implements Authorizable,
UserConstants {
    static final Logger log = LoggerFactory.getLogger(AuthorizableImpl.class);
    final UserManagerImpl userManager;
    private final NodeImpl node;
    private int hashCode;

    protected AuthorizableImpl(NodeImpl node, UserManagerImpl userManager) {
        this.node = node;
        this.userManager = userManager;
    }

    public String getID() throws RepositoryException {
        return Text.unescapeIllegalJcrChars((String)this.getNode().getName());
    }

    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return this.collectMembership(false);
    }

    public Iterator<Group> memberOf() throws RepositoryException {
        return this.collectMembership(true);
    }

    public Iterator<String> getPropertyNames() throws RepositoryException {
        ArrayList<String> l = new ArrayList<String>();
        PropertyIterator it = this.node.getProperties();
        while (it.hasNext()) {
            Property prop = it.nextProperty();
            if (!this.isAuthorizableProperty(prop, false)) continue;
            l.add(prop.getName());
        }
        return l.iterator();
    }

    public Iterator<String> getPropertyNames(String relPath) throws RepositoryException {
        Node n = this.node.getNode(relPath);
        if (n.isSame((Item)this.node)) {
            return this.getPropertyNames();
        }
        if (Text.isDescendant((String)this.node.getPath(), (String)n.getPath())) {
            ArrayList<String> l = new ArrayList<String>();
            PropertyIterator it = n.getProperties();
            while (it.hasNext()) {
                Property prop = it.nextProperty();
                if (!this.isAuthorizableProperty(prop, false)) continue;
                l.add(prop.getName());
            }
            return l.iterator();
        }
        throw new IllegalArgumentException("Relative path " + relPath + " refers to items outside of scope of authorizable " + this.getID());
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.node.hasProperty(relPath) && this.isAuthorizableProperty(this.node.getProperty(relPath), true);
    }

    public Value[] getProperty(String relPath) throws RepositoryException {
        Property prop;
        if (this.node.hasProperty(relPath) && this.isAuthorizableProperty(prop = this.node.getProperty(relPath), true)) {
            if (prop.isMultiple()) {
                return prop.getValues();
            }
            return new Value[]{prop.getValue()};
        }
        return null;
    }

    public synchronized void setProperty(String relPath, Value value) throws RepositoryException {
        String name = Text.getName((String)relPath);
        String intermediate = relPath.equals(name) ? null : Text.getRelativeParent((String)relPath, (int)1);
        this.checkProtectedProperty(name);
        try {
            Property p;
            Node n = this.getOrCreateTargetNode(intermediate);
            if (n.hasProperty(name) && (p = n.getProperty(name)).isMultiple()) {
                p.remove();
            }
            n.setProperty(name, value);
            if (this.userManager.isAutoSave()) {
                this.node.save();
            }
        }
        catch (RepositoryException e) {
            log.debug("Failed to set Property " + name + " for " + this, (Throwable)e);
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized void setProperty(String relPath, Value[] values) throws RepositoryException {
        String name = Text.getName((String)relPath);
        String intermediate = relPath.equals(name) ? null : Text.getRelativeParent((String)relPath, (int)1);
        this.checkProtectedProperty(name);
        try {
            Property p;
            Node n = this.getOrCreateTargetNode(intermediate);
            if (n.hasProperty(name) && !(p = n.getProperty(name)).isMultiple()) {
                p.remove();
            }
            n.setProperty(name, values);
            if (this.userManager.isAutoSave()) {
                this.node.save();
            }
        }
        catch (RepositoryException e) {
            log.debug("Failed to set Property " + name + " for " + this, (Throwable)e);
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized boolean removeProperty(String relPath) throws RepositoryException {
        String name = Text.getName((String)relPath);
        this.checkProtectedProperty(name);
        try {
            Property p;
            if (this.node.hasProperty(relPath) && this.isAuthorizableProperty(p = this.node.getProperty(relPath), true)) {
                p.remove();
                if (this.userManager.isAutoSave()) {
                    this.node.save();
                }
                return true;
            }
            return false;
        }
        catch (RepositoryException e) {
            log.debug("Failed to remove Property " + relPath + " from " + this, (Throwable)e);
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized void remove() throws RepositoryException {
        if (!this.isGroup() && ((User)this).isAdmin()) {
            throw new RepositoryException("The administrator cannot be removed.");
        }
        SessionImpl s = this.getSession();
        this.node.remove();
        if (this.userManager.isAutoSave()) {
            s.save();
        }
    }

    public String getPath() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.userManager.getPath(this.node);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.isGroup() ? "group:" : "user:");
                sb.append(this.getSession().getWorkspace().getName());
                sb.append(":");
                sb.append(this.node.getIdentifier());
                this.hashCode = sb.toString().hashCode();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthorizableImpl) {
            AuthorizableImpl otherAuth = (AuthorizableImpl)obj;
            try {
                return this.isGroup() == otherAuth.isGroup() && this.node.isSame(otherAuth.node);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        try {
            String typeStr = this.isGroup() ? "Group '" : "User '";
            return typeStr + this.getID() + "'";
        }
        catch (RepositoryException e) {
            return super.toString();
        }
    }

    NodeImpl getNode() {
        return this.node;
    }

    SessionImpl getSession() throws RepositoryException {
        return (SessionImpl)this.node.getSession();
    }

    String getPrincipalName() throws RepositoryException {
        return this.node.getProperty(P_PRINCIPAL_NAME).getString();
    }

    boolean isEveryone() throws RepositoryException {
        return this.isGroup() && "everyone".equals(this.getPrincipalName());
    }

    private Iterator<Group> collectMembership(boolean includeIndirect) throws RepositoryException {
        Collection<String> groupNodeIds;
        MembershipCache cache = this.userManager.getMembershipCache();
        String nid = this.node.getIdentifier();
        if (this.node.getSession().hasPendingChanges()) {
            Session session = this.node.getSession();
            groupNodeIds = includeIndirect ? cache.collectMembership(nid, session) : cache.collectDeclaredMembership(nid, session);
        } else {
            groupNodeIds = includeIndirect ? cache.getMemberOf(nid) : cache.getDeclaredMemberOf(nid);
        }
        HashSet<Group> groups = new HashSet<Group>(groupNodeIds.size());
        for (String identifier : groupNodeIds) {
            try {
                NodeImpl n = (NodeImpl)this.getSession().getNodeByIdentifier(identifier);
                Group group = this.userManager.createGroup(n);
                groups.add(group);
            }
            catch (RepositoryException e) {}
        }
        return groups.iterator();
    }

    private boolean isAuthorizableProperty(Property prop, boolean verifyAncestor) throws RepositoryException {
        if (verifyAncestor && !Text.isDescendant((String)this.node.getPath(), (String)prop.getPath())) {
            log.debug("Attempt to access property outside of authorizable scope.");
            return false;
        }
        PropertyDefinition def = prop.getDefinition();
        if (def.isProtected()) {
            return false;
        }
        if (this.node.isSame((Item)prop.getParent())) {
            NodeTypeImpl declaringNt = (NodeTypeImpl)prop.getDefinition().getDeclaringNodeType();
            return declaringNt.isNodeType(UserConstants.NT_REP_AUTHORIZABLE);
        }
        return true;
    }

    private boolean isProtectedProperty(String propertyName) throws RepositoryException {
        Name pName = this.getSession().getQName(propertyName);
        return P_PRINCIPAL_NAME.equals(pName) || P_MEMBERS.equals(pName) || P_IMPERSONATORS.equals(pName) || P_PASSWORD.equals(pName);
    }

    private void checkProtectedProperty(String propertyName) throws ConstraintViolationException, RepositoryException {
        if (this.isProtectedProperty(propertyName)) {
            throw new ConstraintViolationException("Attempt to modify protected property " + propertyName + " of " + this);
        }
    }

    private Node getOrCreateTargetNode(String relPath) throws RepositoryException {
        NodeImpl n;
        if (relPath != null) {
            if (this.node.hasNode(relPath)) {
                n = this.node.getNode(relPath);
            } else {
                n = this.node;
                for (String segment : Text.explode((String)relPath, (int)47)) {
                    n = n.hasNode(segment) ? n.getNode(segment) : n.addNode(segment);
                }
            }
            if (!Text.isDescendantOrEqual((String)this.node.getPath(), (String)n.getPath())) {
                this.node.refresh(false);
                throw new RepositoryException("Relative path " + relPath + " outside of scope of " + this);
            }
        } else {
            n = this.node;
        }
        return n;
    }

    class NodeBasedPrincipal
    extends PrincipalImpl
    implements ItemBasedPrincipal {
        NodeBasedPrincipal(String name) {
            super(name);
        }

        NodeId getNodeId() {
            return AuthorizableImpl.this.node.getNodeId();
        }

        public String getPath() throws RepositoryException {
            return AuthorizableImpl.this.node.getPath();
        }
    }
}

