/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectionHelper
extends ConnectionHelper {
    private static Logger log = LoggerFactory.getLogger(OracleConnectionHelper.class);

    public OracleConnectionHelper(DataSource dataSrc, boolean block) {
        super(dataSrc, true, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Connection connection = this.dataSource.getConnection();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.getDriverMajorVersion() < 10) {
                log.warn("Unsupported driver version detected: " + metaData.getDriverName() + " v" + metaData.getDriverVersion());
            }
        }
        catch (SQLException e) {
            log.warn("Can not retrieve driver version", (Throwable)e);
        }
        finally {
            DbUtility.close(connection, null, null);
        }
    }

    protected final void replaceCharacter(StringBuilder escaped, char c) {
        escaped.append("_");
    }
}

