/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.version.InternalFreezeImpl;
import org.apache.jackrabbit.core.version.InternalFrozenVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class InternalFrozenVHImpl
extends InternalFreezeImpl
implements InternalFrozenVersionHistory {
    public InternalFrozenVHImpl(InternalVersionManagerBase vMgr, NodeStateEx node, InternalVersionItem parent) {
        super(vMgr, node, parent);
    }

    public Name getName() {
        return this.node.getName();
    }

    public NodeId getId() {
        return this.node.getNodeId();
    }

    public NodeId getVersionHistoryId() {
        return this.node.getPropertyValue(NameConstants.JCR_CHILDVERSIONHISTORY).getNodeId();
    }

    public InternalVersionHistory getVersionHistory() throws VersionException {
        try {
            return this.vMgr.getVersionHistory(this.getVersionHistoryId());
        }
        catch (RepositoryException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public NodeId getBaseVersionId() {
        return this.node.getPropertyValue(NameConstants.JCR_BASEVERSION).getNodeId();
    }

    public InternalVersion getBaseVesion() throws VersionException {
        return this.getBaseVersion();
    }

    public InternalVersion getBaseVersion() throws VersionException {
        try {
            InternalVersionHistory history = this.vMgr.getVersionHistory(this.getVersionHistoryId());
            return history.getVersion(this.getBaseVersionId());
        }
        catch (RepositoryException e) {
            throw new VersionException((Throwable)e);
        }
    }
}

