/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.TransactionContext;

public class VersioningLock {
    private final ReadWriteLock rwLock = new ReentrantWriterPreferenceReadWriteLock();
    private final ReadWriteLock xidRwLock = new XidRWLock();

    public ReadLock acquireReadLock() throws InterruptedException {
        if (TransactionContext.getCurrentXid() == null) {
            return new ReadLock(this.rwLock.readLock());
        }
        return new ReadLock(this.xidRwLock.readLock());
    }

    public WriteLock acquireWriteLock() throws InterruptedException {
        if (TransactionContext.getCurrentXid() == null) {
            return new WriteLock(this.rwLock);
        }
        return new WriteLock(this.xidRwLock);
    }

    private static final class XidRWLock
    extends ReentrantWriterPreferenceReadWriteLock {
        private Xid activeXid;

        private XidRWLock() {
        }

        boolean isSameGlobalTx(Xid otherXid) {
            return this.activeXid == otherXid || Arrays.equals(this.activeXid.getGlobalTransactionId(), otherXid.getGlobalTransactionId());
        }

        protected boolean allowReader() {
            Xid currentXid = TransactionContext.getCurrentXid();
            return this.activeXid == null && this.waitingWriters_ == 0L || this.isSameGlobalTx(currentXid);
        }

        protected synchronized boolean startWrite() {
            Xid currentXid = TransactionContext.getCurrentXid();
            if (this.activeXid != null && this.isSameGlobalTx(currentXid)) {
                ++this.writeHolds_;
                return true;
            }
            if (this.writeHolds_ == 0L) {
                if (this.activeReaders_ == 0L || this.readers_.size() == 1 && this.readers_.get(currentXid) != null) {
                    this.activeXid = currentXid;
                    this.writeHolds_ = 1L;
                    return true;
                }
                return false;
            }
            return false;
        }

        protected synchronized WriterPreferenceReadWriteLock.Signaller endWrite() {
            --this.writeHolds_;
            if (this.writeHolds_ > 0L) {
                return null;
            }
            this.activeXid = null;
            if (this.waitingReaders_ > 0L && this.allowReader()) {
                return this.readerLock_;
            }
            if (this.waitingWriters_ > 0L) {
                return this.writerLock_;
            }
            return null;
        }

        protected synchronized boolean startRead() {
            Xid currentXid = TransactionContext.getCurrentXid();
            Object c = this.readers_.get(currentXid);
            if (c != null) {
                this.readers_.put(currentXid, (Integer)c + 1);
                ++this.activeReaders_;
                return true;
            }
            if (this.allowReader()) {
                this.readers_.put(currentXid, IONE);
                ++this.activeReaders_;
                return true;
            }
            return false;
        }

        protected synchronized WriterPreferenceReadWriteLock.Signaller endRead() {
            Xid currentXid = TransactionContext.getCurrentXid();
            Object c = this.readers_.get(currentXid);
            if (c == null) {
                throw new IllegalStateException();
            }
            --this.activeReaders_;
            if (c != IONE) {
                int h = (Integer)c - 1;
                Integer ih = h == 1 ? IONE : new Integer(h);
                this.readers_.put(currentXid, ih);
                return null;
            }
            this.readers_.remove(currentXid);
            if (this.writeHolds_ > 0L) {
                return null;
            }
            if (this.activeReaders_ == 0L && this.waitingWriters_ > 0L) {
                return this.writerLock_;
            }
            return null;
        }
    }

    public static class ReadLock {
        private final Sync readLock;

        private ReadLock(Sync readLock) throws InterruptedException {
            this.readLock = readLock;
            this.readLock.acquire();
        }

        public void release() {
            this.readLock.release();
        }
    }

    public static class WriteLock {
        private ReadWriteLock readWriteLock;

        private WriteLock(ReadWriteLock readWriteLock) throws InterruptedException {
            this.readWriteLock = readWriteLock;
            this.readWriteLock.writeLock().acquire();
        }

        public void release() {
            this.readWriteLock.writeLock().release();
        }

        public ReadLock downgrade() throws InterruptedException {
            ReadLock rLock = new ReadLock(this.readWriteLock.readLock());
            this.release();
            return rLock;
        }
    }
}

