/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BLOBInMemory
extends BLOBFileValue {
    private static Logger log = LoggerFactory.getLogger(BLOBInMemory.class);
    private static final String PREFIX = "0x";
    private byte[] data;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final BLOBInMemory EMPTY = new BLOBInMemory(EMPTY_BYTE_ARRAY);

    private BLOBInMemory(byte[] data) {
        this.data = data;
    }

    static BLOBInMemory getInstance(byte[] data) {
        if (data.length == 0) {
            return EMPTY;
        }
        return new BLOBInMemory(data);
    }

    static boolean isInstance(String s) {
        return s.startsWith(PREFIX);
    }

    static BLOBInMemory getInstance(String s) throws IllegalArgumentException {
        assert (s.startsWith(PREFIX));
        int len = (s = s.substring(PREFIX.length())).length();
        if (len % 2 != 0) {
            String msg = "unable to deserialize byte array " + s + " , length=" + s.length();
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] data = new byte[len /= 2];
        try {
            for (int i = 0; i < len; ++i) {
                data[i] = (byte)(Character.digit(s.charAt(2 * i), 16) << 4 | Character.digit(s.charAt(2 * i + 1), 16));
            }
        }
        catch (NumberFormatException e) {
            String msg = "unable to deserialize byte array " + s;
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return BLOBInMemory.getInstance(data);
    }

    @Override
    void delete(boolean pruneEmptyParentDirs) {
    }

    public void dispose() {
    }

    @Override
    BLOBFileValue copy() throws RepositoryException {
        return this;
    }

    public long getSize() {
        return this.data.length;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder(PREFIX.length() + 2 * this.data.length);
        buff.append(PREFIX);
        for (int i = 0; i < this.data.length; ++i) {
            int c = this.data[i] & 0xFF;
            buff.append(Integer.toHexString(c >> 4));
            buff.append(Integer.toHexString(c & 0xF));
        }
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BLOBInMemory) {
            BLOBInMemory other = (BLOBInMemory)obj;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

