/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyManagerImpl
implements HierarchyManager {
    private static Logger log = LoggerFactory.getLogger(HierarchyManagerImpl.class);
    private static final Name EMPTY_NAME = NameFactoryImpl.getInstance().create("", "");
    protected final NodeId rootNodeId;
    protected final ItemStateManager provider;
    static final int RETURN_NODE = 1;
    static final int RETURN_PROPERTY = 2;
    static final int RETURN_ANY = 3;

    public HierarchyManagerImpl(NodeId rootNodeId, ItemStateManager provider) {
        this.rootNodeId = rootNodeId;
        this.provider = provider;
    }

    public NodeId getRootNodeId() {
        return this.rootNodeId;
    }

    protected ItemId resolvePath(Path.Element[] elements, int next, ItemId id, int typesAllowed) throws ItemStateException, MalformedPathException {
        int i;
        PathBuilder builder = new PathBuilder();
        for (i = 0; i < next; ++i) {
            builder.addLast(elements[i]);
        }
        for (i = next; i < elements.length; ++i) {
            ChildNodeEntry nodeEntry;
            Path.Element elem = elements[i];
            NodeId parentId = (NodeId)id;
            id = null;
            Name name = elem.getName();
            int index = elem.getIndex();
            if (index == 0) {
                index = 1;
            }
            int typeExpected = typesAllowed;
            if (i < elements.length - 1) {
                typeExpected = 1;
            }
            NodeState parentState = (NodeState)this.getItemState(parentId);
            if ((typeExpected & 1) != 0 && (nodeEntry = this.getChildNodeEntry(parentState, name, index)) != null) {
                id = nodeEntry.getId();
            }
            if (id == null && (typeExpected & 2) != 0 && parentState.hasPropertyName(name) && index <= 1) {
                id = new PropertyId(parentState.getNodeId(), name);
            }
            if (id == null) break;
            builder.addLast(elements[i]);
            this.pathResolved(id, builder);
        }
        return id;
    }

    protected ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        return this.provider.getItemState(id);
    }

    protected boolean hasItemState(ItemId id) {
        return this.provider.hasItemState(id);
    }

    protected NodeId getParentId(ItemState state) {
        return state.getParentId();
    }

    protected Set<NodeId> getParentIds(ItemState state, boolean useOverlayed) {
        NodeId parentId;
        Set<NodeId> s;
        if (state.isNode()) {
            NodeState ns = (NodeState)state;
            if (ns.isShareable() && useOverlayed && ns.hasOverlayedState()) {
                ns = (NodeState)ns.getOverlayedState();
            }
            if ((s = ns.getSharedSet()).size() > 1) {
                return s;
            }
        }
        if ((parentId = this.getParentId(state)) != null) {
            s = new LinkedHashSet<NodeId>();
            ((HashSet)s).add(parentId);
            return s;
        }
        return Collections.emptySet();
    }

    protected ChildNodeEntry getChildNodeEntry(NodeState parent, NodeId id) {
        return parent.getChildNodeEntry(id);
    }

    protected ChildNodeEntry getChildNodeEntry(NodeState parent, Name name, int index) {
        return parent.getChildNodeEntry(name, index);
    }

    protected void buildPath(PathBuilder builder, ItemState state) throws ItemStateException, RepositoryException {
        if (state.getId().equals(this.rootNodeId)) {
            builder.addRoot();
            return;
        }
        NodeId parentId = this.getParentId(state);
        if (parentId == null) {
            String msg = "failed to build path of " + state.getId() + ": orphaned item";
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        NodeState parent = (NodeState)this.getItemState(parentId);
        this.buildPath(builder, parent);
        if (state.isNode()) {
            NodeState nodeState = (NodeState)state;
            NodeId id = nodeState.getNodeId();
            ChildNodeEntry entry = this.getChildNodeEntry(parent, id);
            if (entry == null) {
                String msg = "failed to build path of " + state.getId() + ": " + parent.getNodeId() + " has no child entry for " + id;
                log.debug(msg);
                throw new ItemNotFoundException(msg);
            }
            if (entry.getIndex() == 1) {
                builder.addLast(entry.getName());
            } else {
                builder.addLast(entry.getName(), entry.getIndex());
            }
        } else {
            PropertyState propState = (PropertyState)state;
            Name name = propState.getName();
            builder.addLast(name);
        }
    }

    protected ItemId resolvePath(Path path, int typesAllowed) throws RepositoryException {
        Path.Element[] elements = path.getElements();
        NodeId id = this.rootNodeId;
        try {
            return this.resolvePath(elements, 1, id, typesAllowed);
        }
        catch (ItemStateException e) {
            String msg = "failed to retrieve state of intermediary node";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected void pathResolved(ItemId id, PathBuilder builder) throws MalformedPathException {
    }

    @Override
    public final ItemId resolvePath(Path path) throws RepositoryException {
        if (path.denotesRoot()) {
            return this.rootNodeId;
        }
        if (!path.isCanonical()) {
            String msg = "path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        return this.resolvePath(path, 3);
    }

    @Override
    public NodeId resolveNodePath(Path path) throws RepositoryException {
        return (NodeId)this.resolvePath(path, 1);
    }

    @Override
    public PropertyId resolvePropertyPath(Path path) throws RepositoryException {
        return (PropertyId)this.resolvePath(path, 2);
    }

    @Override
    public Path getPath(ItemId id) throws ItemNotFoundException, RepositoryException {
        if (id.equals(this.rootNodeId)) {
            return PathFactoryImpl.getInstance().getRootPath();
        }
        PathBuilder builder = new PathBuilder();
        try {
            this.buildPath(builder, this.getItemState(id));
            return builder.getPath();
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        catch (MalformedPathException mpe) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
    }

    @Override
    public Name getName(ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (itemId.denotesNode()) {
            NodeId nodeId = (NodeId)itemId;
            try {
                NodeState nodeState = (NodeState)this.getItemState(nodeId);
                NodeId parentId = this.getParentId(nodeState);
                if (parentId == null) {
                    return EMPTY_NAME;
                }
                return this.getName(nodeId, parentId);
            }
            catch (NoSuchItemStateException nsis) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new ItemNotFoundException(nodeId.toString());
            }
            catch (ItemStateException ise) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        return ((PropertyId)itemId).getName();
    }

    @Override
    public Name getName(NodeId id, NodeId parentId) throws ItemNotFoundException, RepositoryException {
        NodeState parentState;
        try {
            parentState = (NodeState)this.getItemState(parentId);
        }
        catch (NoSuchItemStateException nsis) {
            String msg = "failed to resolve name of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(id.toString());
        }
        catch (ItemStateException ise) {
            String msg = "failed to resolve name of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        ChildNodeEntry entry = this.getChildNodeEntry(parentState, id);
        if (entry == null) {
            String msg = "failed to resolve name of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        return entry.getName();
    }

    @Override
    public int getDepth(ItemId id) throws ItemNotFoundException, RepositoryException {
        if (id.equals(this.rootNodeId)) {
            return 0;
        }
        try {
            ItemState state = this.getItemState(id);
            NodeId parentId = this.getParentId(state);
            int depth = 0;
            while (parentId != null) {
                ++depth;
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return depth;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine depth of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine depth of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    @Override
    public int getRelativeDepth(NodeId ancestorId, ItemId descendantId) throws ItemNotFoundException, RepositoryException {
        if (ancestorId.equals(descendantId)) {
            return 0;
        }
        int depth = 1;
        try {
            ItemState state = this.getItemState(descendantId);
            NodeId parentId = this.getParentId(state);
            while (parentId != null) {
                if (parentId.equals(ancestorId)) {
                    return depth;
                }
                ++depth;
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return -1;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine depth of " + descendantId + " relative to " + ancestorId;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine depth of " + descendantId + " relative to " + ancestorId;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    @Override
    public boolean isAncestor(NodeId nodeId, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (nodeId.equals(itemId)) {
            return false;
        }
        try {
            ItemState state = this.getItemState(itemId);
            NodeId parentId = this.getParentId(state);
            while (parentId != null) {
                if (parentId.equals(nodeId)) {
                    return true;
                }
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return false;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine degree of relationship of " + nodeId + " and " + itemId;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine degree of relationship of " + nodeId + " and " + itemId;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    @Override
    public boolean isShareAncestor(NodeId ancestor, NodeId descendant) throws ItemNotFoundException, RepositoryException {
        if (ancestor.equals(descendant)) {
            return false;
        }
        try {
            ItemState state = this.getItemState(descendant);
            Set<NodeId> parentIds = this.getParentIds(state, false);
            while (parentIds.size() > 0) {
                if (parentIds.contains(ancestor)) {
                    return true;
                }
                LinkedHashSet<NodeId> grandparentIds = new LinkedHashSet<NodeId>();
                for (NodeId parentId : parentIds) {
                    grandparentIds.addAll(this.getParentIds(this.getItemState(parentId), false));
                }
                parentIds = grandparentIds;
            }
            return false;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine degree of relationship of " + ancestor + " and " + descendant;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine degree of relationship of " + ancestor + " and " + descendant;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    @Override
    public int getShareRelativeDepth(NodeId ancestor, ItemId descendant) throws ItemNotFoundException, RepositoryException {
        if (ancestor.equals(descendant)) {
            return 0;
        }
        int depth = 1;
        try {
            ItemState state = this.getItemState(descendant);
            Set<NodeId> parentIds = this.getParentIds(state, true);
            while (parentIds.size() > 0) {
                if (parentIds.contains(ancestor)) {
                    return depth;
                }
                ++depth;
                LinkedHashSet<NodeId> grandparentIds = new LinkedHashSet<NodeId>();
                for (NodeId parentId : parentIds) {
                    state = this.getItemState(parentId);
                    grandparentIds.addAll(this.getParentIds(state, true));
                }
                parentIds = grandparentIds;
            }
            return -1;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine degree of relationship of " + ancestor + " and " + descendant;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine degree of relationship of " + ancestor + " and " + descendant;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }
}

