/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.security.auth.Subject;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryChecker;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.WorkspaceManager;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.cache.CacheManager;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.cluster.WorkspaceEventChannel;
import org.apache.jackrabbit.core.cluster.WorkspaceListener;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.NodeIdFactory;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateManager;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.check.ConsistencyChecker;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.core.retention.RetentionRegistryImpl;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.token.TokenBasedAuthentication;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.simple.SimpleSecurityManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ManagedMLRUItemStateCacheFactory;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.xml.ClonedInputSource;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.RegistryNamespaceResolver;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RepositoryImpl
extends AbstractRepository
implements Repository,
JackrabbitRepository,
SessionListener,
WorkspaceListener {
    private static Logger log = LoggerFactory.getLogger(RepositoryImpl.class);
    public static final NodeId ROOT_NODE_ID = NodeId.valueOf("cafebabe-cafe-babe-cafe-babecafebabe");
    public static final NodeId SYSTEM_ROOT_NODE_ID = NodeId.valueOf("deadbeef-cafe-babe-cafe-babecafebabe");
    public static final NodeId VERSION_STORAGE_NODE_ID = NodeId.valueOf("deadbeef-face-babe-cafe-babecafebabe");
    public static final NodeId ACTIVITIES_NODE_ID = NodeId.valueOf("deadbeef-face-babe-ac71-babecafebabe");
    public static final NodeId CONFIGURATIONS_NODE_ID = NodeId.valueOf("deadbeef-face-babe-c04f-babecafebabe");
    public static final NodeId NODETYPES_NODE_ID = NodeId.valueOf("deadbeef-cafe-cafe-cafe-babecafebabe");
    private static final String PROPERTIES_RESOURCE = "repository.properties";
    public static final String JACKRABBIT_CLUSTER_ID = "jackrabbit.cluster.id";
    private final Map<String, DescriptorValue> repDescriptors = new HashMap<String, DescriptorValue>();
    protected final RepositoryContext context = new RepositoryContext(this);
    private final VirtualNodeTypeStateManager virtNTMgr;
    private JackrabbitSecurityManager securityMgr;
    private SearchManager systemSearchMgr;
    protected final RepositoryConfig repConfig;
    protected NodeIdFactory nodeIdFactory;
    private final DelegatingObservationDispatcher delegatingDispatcher = new DelegatingObservationDispatcher();
    private final HashMap<String, WorkspaceInfo> wspInfos = new HashMap();
    private final Map<Session, Session> activeSessions = new ReferenceMap(2, 2);
    private boolean disposed;
    private RepositoryLockMechanism repLock;
    private final ReadWriteLock shutdownLock = new WriterPreferenceReadWriteLock();
    private final CacheManager cacheMgr = new CacheManager();
    private WorkspaceEventChannel createWorkspaceEventChannel;

    protected RepositoryImpl(RepositoryConfig repConfig) throws RepositoryException {
        this.repLock = repConfig.getRepositoryLockMechanism();
        this.repLock.init(repConfig.getHomeDir());
        this.repLock.acquire();
        long t0 = System.currentTimeMillis();
        log.info("Starting repository...");
        boolean succeeded = false;
        try {
            int maxIdleTime;
            this.repConfig = repConfig;
            this.context.setFileSystem(repConfig.getFileSystem());
            this.context.setRootNodeId(this.loadRootNodeId());
            this.initRepositoryDescriptors();
            this.context.setNamespaceRegistry(this.createNamespaceRegistry());
            this.context.setNodeTypeRegistry(this.createNodeTypeRegistry());
            this.context.setPrivilegeRegistry(new PrivilegeRegistry(this.context.getNamespaceRegistry(), this.context.getFileSystem()));
            this.context.setItemStateCacheFactory(new ManagedMLRUItemStateCacheFactory(this.cacheMgr));
            DataStore dataStore = repConfig.getDataStore();
            if (dataStore != null) {
                this.context.setDataStore(dataStore);
            }
            this.nodeIdFactory = new NodeIdFactory(repConfig.getHomeDir());
            this.nodeIdFactory.open();
            this.context.setNodeIdFactory(this.nodeIdFactory);
            this.context.setWorkspaceManager(new WorkspaceManager(this));
            for (WorkspaceConfig config : repConfig.getWorkspaceConfigs()) {
                WorkspaceInfo info = this.createWorkspaceInfo(config);
                this.wspInfos.put(config.getName(), info);
            }
            ClusterNode clusterNode = null;
            if (repConfig.getClusterConfig() != null) {
                clusterNode = this.createClusterNode();
                this.context.setClusterNode(clusterNode);
                this.context.getNamespaceRegistry().setEventChannel(clusterNode);
                this.context.getNodeTypeRegistry().setEventChannel(clusterNode);
                this.context.getPrivilegeRegistry().setEventChannel(clusterNode);
                this.createWorkspaceEventChannel = clusterNode;
                clusterNode.setListener(this);
            }
            InternalVersionManagerImpl vMgr = this.createVersionManager(repConfig.getVersioningConfig(), this.delegatingDispatcher);
            this.context.setInternalVersionManager(vMgr);
            if (clusterNode != null) {
                vMgr.setEventChannel(clusterNode.createUpdateChannel(null));
            }
            this.virtNTMgr = new VirtualNodeTypeStateManager(this.context.getNodeTypeRegistry(), this.delegatingDispatcher, NODETYPES_NODE_ID, SYSTEM_ROOT_NODE_ID);
            this.initStartupWorkspaces();
            this.getSystemSearchManager(repConfig.getDefaultWorkspaceName());
            this.initSecurityManager();
            this.virtNTMgr.setSession(this.getSystemSession(repConfig.getDefaultWorkspaceName()));
            if (clusterNode != null) {
                this.setDescriptor(JACKRABBIT_CLUSTER_ID, repConfig.getClusterConfig().getId());
                try {
                    clusterNode.start();
                }
                catch (ClusterException e) {
                    String msg = "Unable to start clustered node, forcing shutdown...";
                    log.error(msg, (Throwable)e);
                    this.shutdown();
                    throw new RepositoryException(msg, (Throwable)e);
                }
            }
            if ((maxIdleTime = repConfig.getWorkspaceMaxIdleTime()) != 0) {
                Thread wspJanitor = new Thread(new WorkspaceJanitor(maxIdleTime * 1000));
                wspJanitor.setName("WorkspaceJanitor");
                wspJanitor.setPriority(1);
                wspJanitor.setDaemon(true);
                wspJanitor.start();
            }
            succeeded = true;
            log.info("Repository started (" + (System.currentTimeMillis() - t0) + "ms)");
        }
        catch (RepositoryException e) {
            log.error("failed to start Repository: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (!succeeded) {
                try {
                    this.shutdown();
                }
                catch (Throwable t) {
                    log.error("In addition to startup fail, another unexpected problem occurred while shutting down the repository again.", t);
                    this.repLock.release();
                }
            }
        }
    }

    protected NamespaceRegistryImpl createNamespaceRegistry() throws RepositoryException {
        return new NamespaceRegistryImpl(this.context.getFileSystem());
    }

    protected NodeTypeRegistry createNodeTypeRegistry() throws RepositoryException {
        return new NodeTypeRegistry(this.context.getNamespaceRegistry(), this.context.getFileSystem());
    }

    RepositoryContext getRepositoryContext() {
        return this.context;
    }

    public CacheManager getCacheManager() {
        return this.cacheMgr;
    }

    private synchronized void initSecurityManager() throws RepositoryException {
        SecurityManagerConfig smc = this.getConfig().getSecurityConfig().getSecurityManagerConfig();
        if (smc == null) {
            log.debug("No configuration entry for SecurityManager. Using org.apache.jackrabbit.core.security.simple.SimpleSecurityManager");
            this.securityMgr = new SimpleSecurityManager();
        } else {
            this.securityMgr = smc.newInstance(JackrabbitSecurityManager.class);
        }
        log.info("SecurityManager = " + this.securityMgr.getClass());
        this.context.setSecurityManager(this.securityMgr);
        String workspaceName = this.getConfig().getDefaultWorkspaceName();
        if (smc != null && smc.getWorkspaceName() != null) {
            workspaceName = smc.getWorkspaceName();
        }
        this.markWorkspaceActive(workspaceName);
        this.securityMgr.init(this, (Session)this.getSystemSession(workspaceName));
    }

    protected InternalVersionManagerImpl createVersionManager(VersioningConfig vConfig, DelegatingObservationDispatcher delegatingDispatcher) throws RepositoryException {
        FileSystem fs = vConfig.getFileSystem();
        PersistenceManager pm = this.createPersistenceManager(vConfig.getHomeDir(), fs, vConfig.getPersistenceManagerConfig());
        ISMLocking ismLocking = vConfig.getISMLocking();
        return new InternalVersionManagerImpl(pm, fs, this.context.getNodeTypeRegistry(), delegatingDispatcher, SYSTEM_ROOT_NODE_ID, VERSION_STORAGE_NODE_ID, ACTIVITIES_NODE_ID, this.context.getItemStateCacheFactory(), ismLocking, this.context.getNodeIdFactory());
    }

    protected void initStartupWorkspaces() throws RepositoryException {
        String wspName = this.repConfig.getDefaultWorkspaceName();
        String secWspName = null;
        SecurityManagerConfig smc = this.repConfig.getSecurityConfig().getSecurityManagerConfig();
        if (smc != null) {
            secWspName = smc.getWorkspaceName();
        }
        try {
            this.wspInfos.get(wspName).initialize();
            if (secWspName != null && !this.wspInfos.containsKey(secWspName)) {
                this.createWorkspace(secWspName);
                log.info("created system workspace: {}", (Object)secWspName);
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to initialize workspace '" + wspName + "'", (Throwable)e);
            log.error("Unable to start repository, forcing shutdown...");
            this.shutdown();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NodeId loadRootNodeId() throws RepositoryException {
        try {
            FileSystemResource uuidFile = new FileSystemResource(this.context.getFileSystem(), "/meta/rootUUID");
            if (uuidFile.exists()) {
                InputStream in = uuidFile.getInputStream();
                try {
                    NodeId nodeId = NodeId.valueOf(IOUtils.toString((InputStream)in, (String)"US-ASCII"));
                    return nodeId;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            uuidFile.makeParentDirs();
            OutputStream out = uuidFile.getOutputStream();
            try {
                out.write(ROOT_NODE_ID.toString().getBytes("US-ASCII"));
                NodeId nodeId = ROOT_NODE_ID;
                return nodeId;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to load or persist the root node identifier", (Throwable)e);
        }
        catch (FileSystemException fse) {
            throw new RepositoryException("Failed to access the root node identifier", (Throwable)fse);
        }
    }

    public static RepositoryImpl create(RepositoryConfig config) throws RepositoryException {
        return new RepositoryImpl(config);
    }

    protected void sanityCheck() throws RepositoryException {
        if (this.disposed) {
            throw new RepositoryException("This repository instance has been shut down.");
        }
    }

    protected SearchManager getSystemSearchManager(String wspName) throws RepositoryException {
        if (this.systemSearchMgr == null && this.repConfig.isSearchEnabled()) {
            this.systemSearchMgr = new SearchManager(null, this.context, this.repConfig, this.getWorkspaceInfo(wspName).itemStateMgr, this.context.getInternalVersionManager().getPersistenceManager(), SYSTEM_ROOT_NODE_ID, null, null);
            SystemSession defSysSession = this.getSystemSession(wspName);
            ObservationManager obsMgr = defSysSession.getWorkspace().getObservationManager();
            obsMgr.addEventListener((EventListener)this.systemSearchMgr, 31, "/" + defSysSession.getJCRName(NameConstants.JCR_SYSTEM), true, null, null, false);
        }
        return this.systemSearchMgr;
    }

    protected ClusterNode createClusterNode() throws RepositoryException {
        try {
            ClusterNode clusterNode = new ClusterNode();
            clusterNode.init(new ExternalEventListener());
            return clusterNode;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getWorkspaceNames() {
        HashMap<String, WorkspaceInfo> hashMap = this.wspInfos;
        synchronized (hashMap) {
            return this.wspInfos.keySet().toArray(new String[this.wspInfos.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceInfo getWorkspaceInfo(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        WorkspaceInfo wspInfo;
        this.sanityCheck();
        HashMap<String, WorkspaceInfo> hashMap = this.wspInfos;
        synchronized (hashMap) {
            wspInfo = this.wspInfos.get(workspaceName);
            if (wspInfo == null) {
                throw new NoSuchWorkspaceException(workspaceName);
            }
        }
        try {
            wspInfo.initialize();
        }
        catch (RepositoryException e) {
            log.error("Unable to initialize workspace '" + workspaceName + "'", (Throwable)e);
            throw new NoSuchWorkspaceException(workspaceName);
        }
        return wspInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWorkspace(String workspaceName) throws RepositoryException {
        HashMap<String, WorkspaceInfo> hashMap = this.wspInfos;
        synchronized (hashMap) {
            if (this.wspInfos.containsKey(workspaceName)) {
                throw new RepositoryException("workspace '" + workspaceName + "' already exists.");
            }
            StringBuffer workspaceConfigContent = null;
            if (this.context.getClusterNode() != null) {
                workspaceConfigContent = new StringBuffer();
            }
            WorkspaceConfig config = this.repConfig.createWorkspaceConfig(workspaceName, workspaceConfigContent);
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(workspaceName, info);
            if (workspaceConfigContent != null && this.createWorkspaceEventChannel != null) {
                InputSource s = new InputSource(new StringReader(workspaceConfigContent.toString()));
                this.createWorkspaceEventChannel.workspaceCreated(workspaceName, new ClonedInputSource(s));
            }
        }
    }

    @Override
    public void externalWorkspaceCreated(String workspaceName, InputSource configTemplate) throws RepositoryException {
        this.createWorkspaceInternal(workspaceName, configTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWorkspaceInternal(String workspaceName, InputSource configTemplate) throws RepositoryException {
        HashMap<String, WorkspaceInfo> hashMap = this.wspInfos;
        synchronized (hashMap) {
            if (this.wspInfos.containsKey(workspaceName)) {
                throw new RepositoryException("workspace '" + workspaceName + "' already exists.");
            }
            WorkspaceConfig config = this.repConfig.createWorkspaceConfig(workspaceName, configTemplate);
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(workspaceName, info);
        }
    }

    protected void createWorkspace(String workspaceName, InputSource configTemplate) throws RepositoryException {
        if (this.createWorkspaceEventChannel == null) {
            this.createWorkspaceInternal(workspaceName, configTemplate);
        } else {
            ClonedInputSource template = new ClonedInputSource(configTemplate);
            this.createWorkspaceInternal(workspaceName, template.cloneInputSource());
            this.createWorkspaceEventChannel.workspaceCreated(workspaceName, template);
        }
    }

    SharedItemStateManager getWorkspaceStateManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getItemStateProvider();
    }

    protected void setReferentialIntegrityChecking(String workspace, boolean enabled) throws RepositoryException {
        SharedItemStateManager manager = this.getWorkspaceStateManager(workspace);
        manager.setCheckReferences(enabled);
    }

    ObservationDispatcher getObservationDispatcher(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getObservationDispatcher();
    }

    SearchManager getSearchManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getSearchManager();
    }

    LockManagerImpl getLockManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getLockManager();
    }

    RetentionRegistry getRetentionRegistry(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getRetentionRegistry();
    }

    SystemSession getSystemSession(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getSystemSession();
    }

    void markWorkspaceActive(String workspaceName) throws RepositoryException {
        this.getWorkspaceInfo(workspaceName).setActive(true);
    }

    protected final SessionImpl createSession(AuthContext loginContext, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        WorkspaceInfo wspInfo = this.getWorkspaceInfo(workspaceName);
        SessionImpl ses = this.createSessionInstance(loginContext, wspInfo.getConfig());
        this.onSessionCreated(ses);
        wspInfo.setIdleTimestamp(0L);
        return ses;
    }

    protected final SessionImpl createSession(Subject subject, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        WorkspaceInfo wspInfo = this.getWorkspaceInfo(workspaceName);
        SessionImpl ses = this.createSessionInstance(subject, wspInfo.getConfig());
        this.onSessionCreated(ses);
        wspInfo.setIdleTimestamp(0L);
        return ses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSessionCreated(SessionImpl session) {
        Map<Session, Session> map = this.activeSessions;
        synchronized (map) {
            session.addListener(this);
            this.activeSessions.put((Session)session, (Session)session);
        }
    }

    private Session extendAuthentication(String workspaceName) throws RepositoryException, AccessDeniedException {
        SessionImpl s;
        Subject subject = null;
        try {
            AccessControlContext acc = AccessController.getContext();
            subject = Subject.getSubject(acc);
        }
        catch (SecurityException e) {
            log.warn("Can't check for preauthentication. Reason:", (Object)e.getMessage());
        }
        if (subject == null) {
            log.debug("No preauthenticated subject found -> return null.");
            return null;
        }
        if (subject.isReadOnly()) {
            log.debug("Preauthenticated Subject is read-only -> create Session");
            s = this.createSession(subject, workspaceName);
        } else {
            log.debug("Found preauthenticated Subject, try to extend authentication");
            AuthContext authCtx = this.context.getSecurityManager().getAuthContext(null, subject, workspaceName);
            try {
                authCtx.login();
                s = this.createSession(authCtx, workspaceName);
            }
            catch (javax.security.auth.login.LoginException e) {
                log.debug("Preauthentication could not be extended");
                s = this.createSession(subject, workspaceName);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.shutdownLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Shutdown lock could not be acquired", e);
        }
        try {
            if (!this.disposed) {
                this.doShutdown();
            }
        }
        finally {
            this.shutdownLock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doShutdown() {
        ArrayList<Session> sa;
        log.info("Shutting down repository...");
        ClusterNode clusterNode = this.context.getClusterNode();
        if (clusterNode != null) {
            clusterNode.stop();
        }
        if (this.securityMgr != null) {
            this.securityMgr.close();
        }
        Map<Session, Session> map = this.activeSessions;
        synchronized (map) {
            sa = new ArrayList<Session>(this.activeSessions.size());
            for (Session session : this.activeSessions.values()) {
                sa.add(session);
            }
        }
        for (Session session : sa) {
            if (session == null) continue;
            session.logout();
        }
        if (this.systemSearchMgr != null) {
            this.systemSearchMgr.close();
        }
        HashMap<String, WorkspaceInfo> i$ = this.wspInfos;
        synchronized (i$) {
            for (WorkspaceInfo wspInfo : this.wspInfos.values()) {
                wspInfo.dispose();
            }
        }
        try {
            InternalVersionManagerImpl m = this.context.getInternalVersionManager();
            if (m != null) {
                m.close();
            }
        }
        catch (Exception e) {
            log.error("Error while closing Version Manager.", (Throwable)e);
        }
        this.repDescriptors.clear();
        DataStore dataStore = this.context.getDataStore();
        if (dataStore != null) {
            try {
                dataStore.close();
            }
            catch (DataStoreException e) {
                log.error("error while closing datastore", (Throwable)((Object)e));
            }
        }
        try {
            this.context.getFileSystem().close();
        }
        catch (FileSystemException e) {
            log.error("error while closing repository file system", (Throwable)e);
        }
        try {
            this.nodeIdFactory.close();
        }
        catch (RepositoryException e) {
            log.error("error while closing repository file system", (Throwable)e);
        }
        this.disposed = true;
        this.notifyAll();
        ScheduledExecutorService executor = this.context.getExecutor();
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.warn("Attempting to forcibly shutdown runaway threads");
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for background threads", (Throwable)e);
        }
        this.repConfig.getConnectionFactory().close();
        if (this.repLock != null) {
            try {
                this.repLock.release();
            }
            catch (RepositoryException e) {
                log.error("failed to release the repository lock", (Throwable)e);
            }
        }
        log.info("Repository has been shutdown");
    }

    public RepositoryConfig getConfig() {
        return this.repConfig;
    }

    protected void initRepositoryDescriptors() throws RepositoryException {
        ValueFactory valFactory = ValueFactoryImpl.getInstance();
        Value valTrue = valFactory.createValue(true);
        Value valFalse = valFactory.createValue(false);
        this.setDescriptor("jcr.repository.name", "Jackrabbit");
        this.setDescriptor("jcr.repository.vendor", "Apache Software Foundation");
        this.setDescriptor("jcr.repository.vendor.url", "http://jackrabbit.apache.org/");
        this.setDescriptor("jcr.specification.name", "Content Repository API for Java(TM) Technology Specification");
        this.setDescriptor("jcr.specification.version", "2.0");
        this.setDescriptor("identifier.stability", "identifier.stability.indefinite.duration");
        this.setDescriptor("level.1.supported", valTrue);
        this.setDescriptor("level.2.supported", valTrue);
        this.setDescriptor("write.supported", valTrue);
        this.setDescriptor("option.node.type.management.supported", valTrue);
        this.setDescriptor("node.type.management.autocreated.definitions.supported", valTrue);
        this.setDescriptor("node.type.management.inheritance", "node.type.management.inheritance.multiple");
        this.setDescriptor("node.type.management.multiple.binary.properties.supported", valTrue);
        this.setDescriptor("node.type.management.multivalued.properties.supported", valTrue);
        this.setDescriptor("node.type.management.orderable.child.nodes.supported", valTrue);
        this.setDescriptor("node.type.management.overrides.supported", valFalse);
        this.setDescriptor("node.type.management.primary.item.name.supported", valTrue);
        Value[] types = new Value[]{valFactory.createValue(2L), valFactory.createValue(6L), valFactory.createValue(5L), valFactory.createValue(12L), valFactory.createValue(4L), valFactory.createValue(3L), valFactory.createValue(7L), valFactory.createValue(8L), valFactory.createValue(9L), valFactory.createValue(1L), valFactory.createValue(11L), valFactory.createValue(10L), valFactory.createValue(0L)};
        this.setDescriptor("node.type.management.property.types", types);
        this.setDescriptor("node.type.management.residual.definitions.supported", valTrue);
        this.setDescriptor("node.type.management.same.name.siblings.supported", valTrue);
        this.setDescriptor("node.type.management.value.constraints.supported", valTrue);
        this.setDescriptor("node.type.management.update.in.use.suported", valFalse);
        this.setDescriptor("option.access.control.supported", valTrue);
        this.setDescriptor("option.journaled.observation.supported", valTrue);
        this.setDescriptor("option.lifecycle.supported", valTrue);
        this.setDescriptor("option.locking.supported", valTrue);
        this.setDescriptor("option.observation.supported", valTrue);
        this.setDescriptor("option.node.and.property.with.same.name.supported", valTrue);
        this.setDescriptor("option.query.sql.supported", valTrue);
        this.setDescriptor("option.retention.supported", valTrue);
        this.setDescriptor("option.shareable.nodes.supported", valTrue);
        this.setDescriptor("option.simple.versioning.supported", valTrue);
        this.setDescriptor("option.transactions.supported", valTrue);
        this.setDescriptor("option.unfiled.content.supported", valFalse);
        this.setDescriptor("option.update.mixin.node.types.supported", valTrue);
        this.setDescriptor("option.update.primary.node.type.supported", valTrue);
        this.setDescriptor("option.versioning.supported", valTrue);
        this.setDescriptor("option.workspace.management.supported", valTrue);
        this.setDescriptor("option.xml.export.supported", valTrue);
        this.setDescriptor("option.xml.import.supported", valTrue);
        this.setDescriptor("option.activities.supported", valTrue);
        this.setDescriptor("option.baselines.supported", valTrue);
        this.setDescriptor("query.full.text.search.supported", valTrue);
        this.setDescriptor("query.joins", "query.joins.inner.outer");
        Value[] languages = new Value[]{valFactory.createValue("javax.jcr.query.JCR-JQOM"), valFactory.createValue("javax.jcr.query.JCR-SQL2")};
        this.setDescriptor("query.languages", languages);
        this.setDescriptor("query.stored.queries.supported", valTrue);
        this.setDescriptor("query.xpath.pos.index", valTrue);
        this.setDescriptor("query.xpath.doc.order", valFalse);
        Properties props = this.getCustomRepositoryDescriptors();
        if (props != null) {
            for (Object o : props.keySet()) {
                String key = (String)o;
                this.setDescriptor(key, props.getProperty(key));
            }
        }
    }

    protected Properties getCustomRepositoryDescriptors() throws RepositoryException {
        InputStream in = RepositoryImpl.class.getResourceAsStream(PROPERTIES_RESOURCE);
        if (in != null) {
            try {
                Properties props = new Properties();
                props.load(in);
                Properties properties = props;
                return properties;
            }
            catch (IOException e) {
                String msg = "Failed to load customized repository properties: " + e.toString();
                log.error(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return null;
    }

    protected void setDescriptor(String desc, String value) {
        this.setDescriptor(desc, ValueFactoryImpl.getInstance().createValue(value));
    }

    protected void setDescriptor(String desc, Value value) {
        this.repDescriptors.put(desc, new DescriptorValue(value));
    }

    protected void setDescriptor(String desc, Value[] values) {
        this.repDescriptors.put(desc, new DescriptorValue(values));
    }

    private PersistenceManager createPersistenceManager(File homeDir, FileSystem fs, PersistenceManagerConfig pmConfig) throws RepositoryException {
        try {
            PersistenceManager pm = pmConfig.newInstance(PersistenceManager.class);
            PMContext pmContext = new PMContext(homeDir, fs, this.context.getRootNodeId(), this.context.getNamespaceRegistry(), this.context.getNodeTypeRegistry(), this.context.getDataStore(), this.context.getRepositoryStatistics());
            pm.init(pmContext);
            return pm;
        }
        catch (Exception e) {
            String msg = "Cannot instantiate persistence manager " + pmConfig.getClassName();
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected SharedItemStateManager createItemStateManager(PersistenceManager persistMgr, boolean usesReferences, ISMLocking locking) throws ItemStateException {
        return new SharedItemStateManager(persistMgr, this.context.getRootNodeId(), this.context.getNodeTypeRegistry(), true, this.context.getItemStateCacheFactory(), locking, this.context.getNodeIdFactory());
    }

    public GarbageCollector createDataStoreGarbageCollector() throws RepositoryException {
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        InternalVersionManagerImpl vm = this.context.getInternalVersionManager();
        PersistenceManager pm = vm.getPersistenceManager();
        pmList.add(pm);
        String[] wspNames = this.getWorkspaceNames();
        SessionImpl[] sessions = new SessionImpl[wspNames.length];
        for (int i = 0; i < wspNames.length; ++i) {
            String wspName = wspNames[i];
            WorkspaceInfo wspInfo = this.getWorkspaceInfo(wspName);
            SystemSession systemSession = SystemSession.create(this.context, wspInfo.getConfig());
            wspInfo.setActive(true);
            wspInfo.initialize();
            sessions[i] = systemSession;
            pm = wspInfo.getPersistenceManager();
            pmList.add(pm);
        }
        IterablePersistenceManager[] ipmList = new IterablePersistenceManager[pmList.size()];
        for (int i = 0; i < pmList.size(); ++i) {
            pm = (PersistenceManager)pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                ipmList = null;
                break;
            }
            ipmList[i] = (IterablePersistenceManager)pm;
        }
        return new GarbageCollector(this.context.getDataStore(), ipmList, sessions);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        try {
            this.shutdownLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException("Login lock could not be acquired", (Throwable)e);
        }
        try {
            Set<TokenCredentials> tokenCreds;
            this.sanityCheck();
            if (workspaceName == null) {
                workspaceName = this.repConfig.getDefaultWorkspaceName();
            }
            this.getWorkspaceInfo(workspaceName);
            if (credentials == null) {
                Session session = this.extendAuthentication(workspaceName);
                if (session != null) {
                    Session session2 = session;
                    return session2;
                }
                log.debug("Attempt to login without Credentials and Subject -> try login with null credentials.");
            }
            AuthContext authCtx = this.context.getSecurityManager().getAuthContext(credentials, new Subject(), workspaceName);
            authCtx.login();
            SessionImpl session = this.createSession(authCtx, workspaceName);
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials sc = (SimpleCredentials)credentials;
                for (String name : sc.getAttributeNames()) {
                    if (TokenBasedAuthentication.isMandatoryAttribute(name)) continue;
                    session.setAttribute(name, sc.getAttribute(name));
                }
            }
            if (!(tokenCreds = session.getSubject().getPublicCredentials(TokenCredentials.class)).isEmpty()) {
                TokenCredentials tc = tokenCreds.iterator().next();
                for (String name : tc.getAttributeNames()) {
                    if (TokenBasedAuthentication.isMandatoryAttribute(name)) continue;
                    session.setAttribute(name, tc.getAttribute(name));
                }
            }
            log.debug("User {} logged in to workspace {}", (Object)session.getUserID(), (Object)workspaceName);
            SessionImpl sessionImpl = session;
            return sessionImpl;
        }
        catch (SecurityException se) {
            throw new LoginException("Unable to access authentication information", (Throwable)se);
        }
        catch (javax.security.auth.login.LoginException le) {
            throw new LoginException(le.getMessage(), (Throwable)le);
        }
        catch (AccessDeniedException ade) {
            throw new LoginException("Workspace access denied", (Throwable)ade);
        }
        finally {
            this.shutdownLock.readLock().release();
        }
    }

    public String getDescriptor(String key) {
        Value v = this.getDescriptorValue(key);
        try {
            return v == null ? null : v.getString();
        }
        catch (RepositoryException e) {
            log.error("corrupt descriptor value: " + key, (Throwable)e);
            return null;
        }
    }

    public String[] getDescriptorKeys() {
        Object[] keys = this.repDescriptors.keySet().toArray(new String[this.repDescriptors.keySet().size()]);
        Arrays.sort(keys);
        return keys;
    }

    public Value getDescriptorValue(String key) {
        DescriptorValue descVal = this.repDescriptors.get(key);
        return descVal != null ? descVal.getValue() : null;
    }

    public Value[] getDescriptorValues(String key) {
        DescriptorValue descVal = this.repDescriptors.get(key);
        return descVal != null ? descVal.getValues() : null;
    }

    public boolean isSingleValueDescriptor(String key) {
        DescriptorValue descVal = this.repDescriptors.get(key);
        return descVal != null && descVal.getValue() != null;
    }

    @Override
    public void loggingOut(SessionImpl session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loggedOut(SessionImpl session) {
        Map<Session, Session> map = this.activeSessions;
        synchronized (map) {
            this.activeSessions.remove((Object)session);
        }
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new XASessionImpl(this.context, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new XASessionImpl(this.context, subject, wspConfig);
    }

    protected WorkspaceInfo createWorkspaceInfo(WorkspaceConfig wspConfig) {
        return new WorkspaceInfo(wspConfig);
    }

    protected static final class DescriptorValue {
        private Value val;
        private Value[] vals;

        protected DescriptorValue(Value val) {
            this.val = val;
        }

        protected DescriptorValue(Value[] vals) {
            this.vals = vals;
        }

        protected Value getValue() {
            return this.val;
        }

        protected Value[] getValues() {
            Value[] valueArray;
            if (this.vals != null) {
                valueArray = this.vals;
            } else {
                Value[] valueArray2 = new Value[1];
                valueArray = valueArray2;
                valueArray2[0] = this.val;
            }
            return valueArray;
        }
    }

    class ExternalEventListener
    implements ClusterContext {
        ExternalEventListener() {
        }

        @Override
        public ClusterConfig getClusterConfig() {
            return RepositoryImpl.this.getConfig().getClusterConfig();
        }

        @Override
        public File getRepositoryHome() {
            return new File(RepositoryImpl.this.getConfig().getHomeDir());
        }

        @Override
        public NamespaceResolver getNamespaceResolver() {
            return new RegistryNamespaceResolver((NamespaceRegistry)RepositoryImpl.this.context.getNamespaceRegistry());
        }

        @Override
        public void updateEventsReady(String workspace) throws RepositoryException {
            RepositoryImpl.this.getWorkspaceInfo(workspace);
        }

        @Override
        public void lockEventsReady(String workspace) throws RepositoryException {
            RepositoryImpl.this.getWorkspaceInfo(workspace).getLockManager();
        }
    }

    private class WorkspaceJanitor
    implements Runnable {
        private long maxIdleTime;
        private long checkInterval;

        WorkspaceJanitor(long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            this.checkInterval = (long)(0.1 * (double)maxIdleTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: while (true) {
                HashSet wspNames;
                RepositoryImpl repositoryImpl = RepositoryImpl.this;
                synchronized (repositoryImpl) {
                    try {
                        RepositoryImpl.this.wait(this.checkInterval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (RepositoryImpl.this.disposed) {
                        return;
                    }
                }
                Map e = RepositoryImpl.this.wspInfos;
                synchronized (e) {
                    wspNames = new HashSet(RepositoryImpl.this.wspInfos.keySet());
                }
                wspNames.remove(RepositoryImpl.this.repConfig.getDefaultWorkspaceName());
                e = RepositoryImpl.this.activeSessions;
                synchronized (e) {
                    for (Session ses : RepositoryImpl.this.activeSessions.values()) {
                        wspNames.remove(ses.getWorkspace().getName());
                    }
                }
                Iterator i$ = wspNames.iterator();
                while (true) {
                    WorkspaceInfo wspInfo;
                    if (!i$.hasNext()) continue block14;
                    String wspName = (String)i$.next();
                    HashMap hashMap = RepositoryImpl.this.wspInfos;
                    synchronized (hashMap) {
                        wspInfo = (WorkspaceInfo)RepositoryImpl.this.wspInfos.get(wspName);
                    }
                    wspInfo.disposeIfIdle(this.maxIdleTime);
                }
                break;
            }
        }
    }

    protected class WorkspaceInfo
    implements UpdateEventListener {
        private final WorkspaceConfig config;
        private FileSystem fs;
        private PersistenceManager persistMgr;
        private SharedItemStateManager itemStateMgr;
        private ObservationDispatcher dispatcher;
        private SystemSession systemSession;
        private SearchManager searchMgr;
        private LockManagerImpl lockMgr;
        private RetentionRegistryImpl retentionReg;
        private boolean initialized;
        private boolean active;
        private final ReadWriteLock initLock = new ReentrantWriterPreferenceReadWriteLock();
        private long idleTimestamp;
        private final Mutex xaLock = new Mutex();
        private UpdateEventChannel updateChannel;
        private LockEventChannel lockChannel;

        protected WorkspaceInfo(WorkspaceConfig config) {
            this.config = config;
            this.idleTimestamp = 0L;
            this.initialized = false;
        }

        protected String getName() {
            return this.config.getName();
        }

        public WorkspaceConfig getConfig() {
            return this.config;
        }

        final long getIdleTimestamp() {
            return this.idleTimestamp;
        }

        final void setIdleTimestamp(long ts) {
            this.idleTimestamp = ts;
        }

        protected final boolean isInitialized() {
            try {
                if (!this.initLock.readLock().attempt(0L)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            boolean ret = this.initialized;
            this.initLock.readLock().release();
            return ret;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        protected FileSystem getFileSystem() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.fs;
        }

        protected PersistenceManager getPersistenceManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.persistMgr;
        }

        protected SharedItemStateManager getItemStateProvider() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.itemStateMgr;
        }

        protected ObservationDispatcher getObservationDispatcher() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SearchManager getSearchManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.searchMgr == null && this.config.isSearchEnabled()) {
                    this.searchMgr = new SearchManager(this.getName(), RepositoryImpl.this.context, this.config, this.itemStateMgr, this.persistMgr, RepositoryImpl.this.context.getRootNodeId(), RepositoryImpl.this.getSystemSearchManager(this.getName()), SYSTEM_ROOT_NODE_ID);
                }
                return this.searchMgr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LockManagerImpl getLockManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.lockMgr == null) {
                    this.lockMgr = this.createLockManager();
                    ClusterNode clusterNode = RepositoryImpl.this.context.getClusterNode();
                    if (clusterNode != null && this.config.isClustered()) {
                        this.lockChannel = clusterNode.createLockChannel(this.getName());
                        this.lockMgr.setEventChannel(this.lockChannel);
                    }
                }
                return this.lockMgr;
            }
        }

        protected LockManagerImpl createLockManager() throws RepositoryException {
            return new LockManagerImpl(this.getSystemSession(), this.fs, RepositoryImpl.this.context.getExecutor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RetentionRegistry getRetentionRegistry() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.retentionReg == null) {
                    this.retentionReg = new RetentionRegistryImpl(this.getSystemSession(), this.fs);
                }
                return this.retentionReg;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SystemSession getSystemSession() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.systemSession == null) {
                    this.systemSession = SystemSession.create(RepositoryImpl.this.context, this.config);
                }
                return this.systemSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean initialize() throws RepositoryException {
            try {
                this.initLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Unable to aquire read lock.", (Throwable)e);
            }
            try {
                if (this.initialized) {
                    boolean e = false;
                    return e;
                }
            }
            finally {
                this.initLock.readLock().release();
            }
            try {
                this.initLock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Unable to aquire write lock.", (Throwable)e);
            }
            try {
                if (this.initialized) {
                    boolean bl = false;
                    return bl;
                }
                log.info("initializing workspace '" + this.getName() + "'...");
                this.doInitialize();
                this.initialized = true;
                this.doPostInitialize();
                log.info("workspace '" + this.getName() + "' initialized");
                boolean bl = true;
                return bl;
            }
            finally {
                this.initLock.writeLock().release();
            }
        }

        protected void doInitialize() throws RepositoryException {
            this.fs = this.config.getFileSystem();
            this.persistMgr = RepositoryImpl.this.createPersistenceManager(new File(this.config.getHomeDir()), this.fs, this.config.getPersistenceManagerConfig());
            this.doVersionRecovery();
            ISMLocking ismLocking = this.config.getISMLocking();
            try {
                this.itemStateMgr = RepositoryImpl.this.createItemStateManager(this.persistMgr, true, ismLocking);
                try {
                    this.itemStateMgr.addVirtualItemStateProvider(RepositoryImpl.this.context.getInternalVersionManager().getVirtualItemStateProvider());
                    this.itemStateMgr.addVirtualItemStateProvider(RepositoryImpl.this.virtNTMgr.getVirtualItemStateProvider());
                }
                catch (Exception e) {
                    log.error("Unable to add vmgr: " + e.toString(), (Throwable)e);
                }
                ClusterNode clusterNode = RepositoryImpl.this.context.getClusterNode();
                if (clusterNode != null && this.config.isClustered()) {
                    this.updateChannel = clusterNode.createUpdateChannel(this.getName());
                    this.itemStateMgr.setEventChannel(this.updateChannel);
                    this.updateChannel.setListener(this);
                    if (this.persistMgr instanceof ConsistencyChecker) {
                        ((ConsistencyChecker)((Object)this.persistMgr)).setEventChannel(this.updateChannel);
                    }
                }
            }
            catch (ItemStateException ise) {
                String msg = "failed to instantiate shared item state manager";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
            this.dispatcher = new ObservationDispatcher();
            RepositoryImpl.this.delegatingDispatcher.addDispatcher(this.dispatcher);
        }

        protected void doVersionRecovery() throws RepositoryException {
            if (Boolean.getBoolean("org.apache.jackrabbit.version.recovery")) {
                RepositoryChecker checker = new RepositoryChecker(this.persistMgr, RepositoryImpl.this.context.getInternalVersionManager());
                checker.check(ROOT_NODE_ID, true, true);
            }
        }

        protected void doPostInitialize() throws RepositoryException {
            WorkspaceImpl wsp = (WorkspaceImpl)this.getSystemSession().getWorkspace();
            log.debug("initializing SearchManager...");
            long t0 = System.currentTimeMillis();
            SearchManager searchMgr = this.getSearchManager();
            if (searchMgr != null) {
                wsp.getObservationManager().addEventListener((EventListener)searchMgr, 31, "/", true, null, null, false);
            }
            log.debug("SearchManager initialized (" + (System.currentTimeMillis() - t0) + "ms)");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void disposeIfIdle(long maxIdleTime) {
            try {
                this.initLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                if (!this.initialized || this.active) {
                    return;
                }
                long currentTS = System.currentTimeMillis();
                if (this.idleTimestamp == 0L) {
                    this.idleTimestamp = currentTS;
                } else if (currentTS - this.idleTimestamp > maxIdleTime) {
                    log.info("disposing workspace '" + this.getName() + "' which has been idle for " + (currentTS - this.idleTimestamp) + " ms");
                    this.dispose();
                }
            }
            finally {
                this.initLock.readLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void dispose() {
            try {
                this.initLock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Unable to aquire write lock.");
            }
            try {
                if (!this.initialized) {
                    return;
                }
                log.info("shutting down workspace '" + this.getName() + "'...");
                this.doDispose();
                this.idleTimestamp = 0L;
                this.active = false;
                this.initialized = false;
                log.info("workspace '" + this.getName() + "' has been shutdown");
            }
            finally {
                this.initLock.writeLock().release();
            }
        }

        protected void doDispose() {
            if (this.updateChannel != null) {
                this.updateChannel.setListener(null);
            }
            if (this.lockChannel != null) {
                this.lockChannel.setListener(null);
            }
            RepositoryImpl.this.delegatingDispatcher.removeDispatcher(this.dispatcher);
            this.dispatcher.dispose();
            this.dispatcher = null;
            if (this.searchMgr != null) {
                this.searchMgr.close();
                this.searchMgr = null;
            }
            if (RepositoryImpl.this.securityMgr != null) {
                RepositoryImpl.this.securityMgr.dispose(this.getName());
            }
            if (this.systemSession != null) {
                this.systemSession.removeListener(RepositoryImpl.this);
                this.systemSession.logout();
                this.systemSession = null;
            }
            this.itemStateMgr.dispose();
            this.itemStateMgr = null;
            try {
                this.persistMgr.close();
            }
            catch (Exception e) {
                log.error("error while closing persistence manager of workspace " + this.config.getName(), (Throwable)e);
            }
            this.persistMgr = null;
            if (this.lockMgr != null) {
                this.lockMgr.close();
                this.lockMgr = null;
            }
            if (this.retentionReg != null) {
                this.retentionReg.close();
                this.retentionReg = null;
            }
            try {
                this.fs.close();
            }
            catch (FileSystemException fse) {
                log.error("error while closing file system of workspace " + this.config.getName(), (Throwable)fse);
            }
            this.fs = null;
        }

        void lockAcquire() throws TransactionException {
            try {
                this.xaLock.acquire();
            }
            catch (InterruptedException e) {
                throw new TransactionException("Error while acquiering lock", e);
            }
        }

        void lockRelease() {
            this.xaLock.release();
        }

        @Override
        public void externalUpdate(ChangeLog external, List<EventState> events, long timestamp, String userData) throws RepositoryException {
            try {
                EventStateCollection esc = new EventStateCollection(this.getObservationDispatcher(), null, null);
                esc.setUserData(userData);
                esc.addAll(events);
                esc.setTimestamp(timestamp);
                this.getItemStateProvider().externalUpdate(external, esc);
            }
            catch (IllegalStateException e) {
                String msg = "Unable to deliver events: " + e.getMessage();
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
    }
}

