/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePropBundle {
    private static Logger log = LoggerFactory.getLogger(NodePropBundle.class);
    private final NodeId id;
    private NodeId parentId;
    private Name nodeTypeName;
    private Set<Name> mixinTypeNames;
    private LinkedList<ChildNodeEntry> childNodeEntries = new LinkedList();
    private HashMap<Name, PropertyEntry> properties = new HashMap();
    private boolean isNew = true;
    private boolean isReferenceable;
    private short modCount;
    private long size;
    private Set<NodeId> sharedSet;

    public NodePropBundle(NodeId id) {
        this.id = id;
    }

    public NodePropBundle(NodeState state) {
        this(state.getNodeId());
        this.update(state);
    }

    public void update(NodeState state) {
        if (!this.id.equals(state.getNodeId())) {
            throw new IllegalArgumentException("Not allowed to update foreign state.");
        }
        this.parentId = state.getParentId();
        this.nodeTypeName = state.getNodeTypeName();
        this.mixinTypeNames = state.getMixinTypeNames();
        this.isReferenceable = state.hasPropertyName(NameConstants.JCR_UUID);
        this.modCount = state.getModCount();
        List<org.apache.jackrabbit.core.state.ChildNodeEntry> list = state.getChildNodeEntries();
        this.childNodeEntries.clear();
        for (org.apache.jackrabbit.core.state.ChildNodeEntry cne : list) {
            this.addChildNodeEntry(cne.getName(), cne.getId());
        }
        this.sharedSet = state.getSharedSet();
    }

    public NodeState createNodeState(PersistenceManager pMgr) {
        NodeState state = pMgr.createNew(this.id);
        state.setParentId(this.parentId);
        state.setNodeTypeName(this.nodeTypeName);
        state.setMixinTypeNames(this.mixinTypeNames);
        state.setModCount(this.modCount);
        for (ChildNodeEntry e : this.childNodeEntries) {
            state.addChildNodeEntry(e.getName(), e.getId());
        }
        state.setPropertyNames(this.properties.keySet());
        state.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
        if (this.mixinTypeNames.size() > 0) {
            state.addPropertyName(NameConstants.JCR_MIXINTYPES);
        }
        if (this.isReferenceable) {
            state.addPropertyName(NameConstants.JCR_UUID);
        }
        for (NodeId nodeId : this.sharedSet) {
            state.addShare(nodeId);
        }
        return state;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void markOld() {
        this.isNew = false;
    }

    public NodeId getId() {
        return this.id;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public void setParentId(NodeId parentId) {
        this.parentId = parentId;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public void setNodeTypeName(Name nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public Set<Name> getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public void setMixinTypeNames(Set<Name> mixinTypeNames) {
        this.mixinTypeNames = mixinTypeNames;
    }

    public boolean isReferenceable() {
        return this.isReferenceable;
    }

    public void setReferenceable(boolean referenceable) {
        this.isReferenceable = referenceable;
    }

    public short getModCount() {
        return this.modCount;
    }

    public void setModCount(short modCount) {
        this.modCount = modCount;
    }

    public List<ChildNodeEntry> getChildNodeEntries() {
        return this.childNodeEntries;
    }

    public void addChildNodeEntry(Name name, NodeId id) {
        this.childNodeEntries.add(new ChildNodeEntry(name, id));
    }

    public void addProperty(PropertyEntry entry) {
        assert (!NameConstants.JCR_PRIMARYTYPE.equals(entry.getName()));
        assert (!NameConstants.JCR_MIXINTYPES.equals(entry.getName()));
        assert (!NameConstants.JCR_UUID.equals(entry.getName()));
        this.properties.put(entry.getName(), entry);
    }

    public void addProperty(PropertyState state, BLOBStore blobStore) {
        PropertyEntry old = this.properties.put(state.getName(), new PropertyEntry(state));
        if (old != null) {
            old.destroy(blobStore);
        }
    }

    public boolean hasProperty(Name name) {
        return this.properties.containsKey(name);
    }

    public Set<Name> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<PropertyEntry> getPropertyEntries() {
        return this.properties.values();
    }

    public PropertyEntry getPropertyEntry(Name name) {
        return this.properties.get(name);
    }

    public void removeAllProperties(BLOBStore blobStore) {
        for (Name name : new HashSet<Name>(this.properties.keySet())) {
            this.removeProperty(name, blobStore);
        }
    }

    public void removeProperty(Name name, BLOBStore blobStore) {
        PropertyEntry pe = this.properties.remove(name);
        if (pe != null) {
            pe.destroy(blobStore);
        }
    }

    public Set<NodeId> getSharedSet() {
        return this.sharedSet;
    }

    public void setSharedSet(Set<NodeId> sharedSet) {
        this.sharedSet = sharedSet;
    }

    public long getSize() {
        return 500L + this.size + (long)(300 * (this.childNodeEntries.size() + this.properties.size() + 3));
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        builder.append("(");
        builder.append(this.parentId);
        builder.append(",");
        builder.append(this.nodeTypeName);
        for (Name mixin : this.mixinTypeNames) {
            builder.append(",");
            builder.append(mixin);
        }
        if (this.isReferenceable) {
            builder.append(",referenceable");
        }
        builder.append(") = ");
        if (!this.sharedSet.isEmpty()) {
            builder.append(this.sharedSet);
            builder.append(" ");
        }
        builder.append(this.properties.values());
        builder.append(" ");
        builder.append(this.childNodeEntries);
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof NodePropBundle) {
            NodePropBundle that = (NodePropBundle)object;
            return this.id.equals(that.id) && this.parentId.equals(that.parentId) && this.nodeTypeName.equals(that.nodeTypeName) && ((Object)this.mixinTypeNames).equals(that.mixinTypeNames) && this.isReferenceable == that.isReferenceable && ((Object)this.sharedSet).equals(that.sharedSet) && this.properties.equals(that.properties) && this.childNodeEntries.equals(that.childNodeEntries);
        }
        return false;
    }

    public static class PropertyEntry {
        private final PropertyId id;
        private InternalValue[] values;
        private int type;
        private boolean multiValued;
        private String[] blobIds;
        private short modCount;

        public PropertyEntry(PropertyId id) {
            this.id = id;
        }

        public PropertyEntry(PropertyState state) {
            this((PropertyId)state.getId());
            this.values = state.getValues();
            this.type = state.getType();
            this.multiValued = state.isMultiValued();
            this.modCount = state.getModCount();
            if (this.type == 2) {
                this.blobIds = new String[this.values.length];
            }
        }

        public PropertyId getId() {
            return this.id;
        }

        public Name getName() {
            return this.id.getName();
        }

        public InternalValue[] getValues() {
            return this.values;
        }

        public void setValues(InternalValue[] values) {
            this.values = values;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public String getBlobId(int n) {
            return this.blobIds[n];
        }

        public void setBlobIds(String[] blobIds) {
            this.blobIds = blobIds;
        }

        public void setBlobId(String blobId, int n) {
            this.blobIds[n] = blobId;
        }

        public short getModCount() {
            return this.modCount;
        }

        public void setModCount(short modCount) {
            this.modCount = modCount;
        }

        private void destroy(BLOBStore blobStore) {
            for (int i = 0; this.blobIds != null && i < this.blobIds.length; ++i) {
                if (this.blobIds[i] == null) continue;
                try {
                    blobStore.remove(this.blobIds[i]);
                    log.debug("removed blob {}", (Object)this.blobIds[i]);
                    continue;
                }
                catch (Exception e) {
                    log.error("Ignoring error while removing blob " + this.blobIds[i], (Throwable)e);
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.id);
            builder.append("(");
            builder.append(PropertyType.nameFromValue((int)this.type));
            if (this.multiValued) {
                builder.append(",multiple");
            }
            builder.append(") = ");
            builder.append(Arrays.toString((Object[])this.values));
            return builder.toString();
        }

        public boolean equals(Object object) {
            if (object instanceof PropertyEntry) {
                PropertyEntry that = (PropertyEntry)object;
                return this.id.equals(that.id) && this.type == that.type && this.multiValued == that.multiValued && Arrays.equals((Object[])this.values, (Object[])that.values);
            }
            return false;
        }
    }

    public static class ChildNodeEntry {
        private final Name name;
        private final NodeId id;

        public ChildNodeEntry(Name name, NodeId id) {
            this.name = name;
            this.id = id;
        }

        public Name getName() {
            return this.name;
        }

        public NodeId getId() {
            return this.id;
        }

        public String toString() {
            return this.name + " => " + this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof ChildNodeEntry) {
                ChildNodeEntry that = (ChildNodeEntry)object;
                return this.name.equals(that.name) && this.id.equals(that.id);
            }
            return false;
        }
    }
}

