/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.config.BeanFactory;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.SimpleBeanFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfig {
    private static Logger log = LoggerFactory.getLogger(BeanConfig.class);
    private static final Map<String, String> DEPRECATIONS;
    private static ClassLoader defaultClassLoader;
    private BeanFactory instanceFactory = new SimpleBeanFactory();
    private ClassLoader classLoader = BeanConfig.getDefaultClassLoader();
    private final String className;
    private final Properties properties;
    private ConnectionFactory connectionFactory = null;
    private boolean validate = true;

    public BeanConfig(String className, Properties properties) {
        if (DEPRECATIONS.containsKey(className)) {
            String replacement = DEPRECATIONS.get(className);
            log.info("{} is deprecated. Please use {} instead", (Object)className, (Object)replacement);
            className = replacement;
        }
        this.className = className;
        this.properties = (Properties)properties.clone();
    }

    public BeanConfig(BeanConfig config) {
        this(config.getClassName(), config.getParameters());
        this.setConnectionFactory(config.connectionFactory);
    }

    protected void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setInstanceFactory(BeanFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getParameters() {
        return this.properties;
    }

    public <T> T newInstance(Class<T> klass) throws ConfigurationException {
        String cname = this.getClassName();
        Object instance = this.instanceFactory.newInstance(klass, this);
        Class<?> objectClass = instance.getClass();
        Map<String, Method> setters = this.getSetters(objectClass);
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement().toString();
            Method setter = setters.get(name);
            if (setter != null) {
                if (setter.getAnnotation(Deprecated.class) != null) {
                    log.warn("Parameter {} of {} has been deprecated", (Object)name, (Object)cname);
                }
                String value = this.properties.getProperty(name);
                this.setProperty(instance, name, setter, value);
                continue;
            }
            if (!this.validate) continue;
            throw new ConfigurationException("Configured class " + cname + " does not contain a property named " + name);
        }
        if (instance instanceof DatabaseAware) {
            ((DatabaseAware)instance).setConnectionFactory(this.connectionFactory);
        }
        return (T)instance;
    }

    private Map<String, Method> getSetters(Class<?> klass) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : klass.getMethods()) {
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length != 1) continue;
            methods.put(name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4), method);
        }
        return methods;
    }

    private void setProperty(Object instance, String name, Method setter, String value) throws ConfigurationException {
        block10: {
            Class<Object> type = setter.getParameterTypes()[0];
            try {
                if (type.isAssignableFrom(String.class) || type.isAssignableFrom(Object.class)) {
                    setter.invoke(instance, value);
                    break block10;
                }
                if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
                    setter.invoke(instance, Boolean.valueOf(value));
                    break block10;
                }
                if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    setter.invoke(instance, Integer.valueOf(value));
                    break block10;
                }
                if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                    setter.invoke(instance, Long.valueOf(value));
                    break block10;
                }
                if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    setter.invoke(instance, Double.valueOf(value));
                    break block10;
                }
                throw new ConfigurationException("The type (" + type.getName() + ") of property " + name + " of class " + this.getClassName() + " is not supported");
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid number format (" + value + ") for property " + name + " of class " + this.getClassName(), (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Property " + name + " of class " + this.getClassName() + " can not be set to \"" + value + "\"", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("The setter of property " + name + " of class " + this.getClassName() + " can not be accessed", (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Unable to call the setter of property " + name + " of class " + this.getClassName(), (Exception)e);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        defaultClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            HashMap<String, String> temp = new HashMap<String, String>();
            Properties props = new Properties();
            InputStream in = BeanConfig.class.getResourceAsStream("deprecated-classes.properties");
            try {
                props.load(in);
            }
            finally {
                in.close();
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                temp.put(entry.getKey().toString(), entry.getValue().toString());
            }
            DEPRECATIONS = Collections.unmodifiableMap(temp);
        }
        catch (IOException e) {
            throw new InternalError("failed to read deprecated classes");
        }
        defaultClassLoader = BeanConfig.class.getClassLoader();
    }
}

