/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.value.ValueHelper;

public abstract class AccessControlEntryImpl
implements JackrabbitAccessControlEntry {
    private Privilege[] privileges;
    private final PrivilegeBits privilegeBits;
    private final Principal principal;
    private final boolean allow;
    private final Map<Name, Value> restrictions;
    private int hashCode = -1;

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
        if (principal == null || privileges == null) {
            throw new AccessControlException();
        }
        for (Privilege privilege : privileges) {
            if (!privilege.isAbstract()) continue;
            throw new AccessControlException("Privilege " + privilege + " is abstract.");
        }
        this.principal = principal;
        this.privileges = privileges;
        this.privilegeBits = this.getPrivilegeManager().getBits(privileges).unmodifiable();
        this.allow = isAllow;
        if (restrictions == null) {
            this.restrictions = Collections.emptyMap();
        } else {
            this.restrictions = new HashMap<Name, Value>(restrictions.size());
            for (String name : restrictions.keySet()) {
                Value value = ValueHelper.copy((Value)restrictions.get(name), (ValueFactory)this.getValueFactory());
                this.restrictions.put(this.getResolver().getQName(name), value);
            }
        }
    }

    protected AccessControlEntryImpl(Principal principal, PrivilegeBits privilegesBits, boolean isAllow, Map<String, Value> restrictions) throws RepositoryException {
        if (principal == null || privilegesBits == null) {
            throw new IllegalArgumentException();
        }
        this.principal = principal;
        this.privilegeBits = privilegesBits.unmodifiable();
        this.allow = isAllow;
        if (restrictions == null) {
            this.restrictions = Collections.emptyMap();
        } else {
            this.restrictions = new HashMap<Name, Value>(restrictions.size());
            for (String name : restrictions.keySet()) {
                Value value = ValueHelper.copy((Value)restrictions.get(name), (ValueFactory)this.getValueFactory());
                this.restrictions.put(this.getResolver().getQName(name), value);
            }
        }
    }

    protected AccessControlEntryImpl(AccessControlEntryImpl base, PrivilegeBits privilegeBits, boolean isAllow) throws AccessControlException, RepositoryException {
        this(base.principal, privilegeBits, isAllow, base.restrictions.isEmpty() ? null : Collections.emptyMap());
        if (!base.restrictions.isEmpty()) {
            for (Name name : base.restrictions.keySet()) {
                Value value = ValueHelper.copy((Value)base.restrictions.get(name), (ValueFactory)this.getValueFactory());
                this.restrictions.put(name, value);
            }
        }
    }

    protected AccessControlEntryImpl(AccessControlEntryImpl base, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        this(base.principal, privileges, isAllow, base.restrictions.isEmpty() ? null : Collections.emptyMap());
        if (!base.restrictions.isEmpty()) {
            for (Name name : base.restrictions.keySet()) {
                Value value = ValueHelper.copy((Value)base.restrictions.get(name), (ValueFactory)this.getValueFactory());
                this.restrictions.put(name, value);
            }
        }
    }

    public PrivilegeBits getPrivilegeBits() {
        return this.privilegeBits;
    }

    public boolean hasRestrictions() {
        return !this.restrictions.isEmpty();
    }

    public Map<Name, Value> getRestrictions() {
        return Collections.unmodifiableMap(this.restrictions);
    }

    public Value getRestriction(Name restrictionName) {
        return ValueHelper.copy((Value)this.restrictions.get(restrictionName), (ValueFactory)this.getValueFactory());
    }

    protected abstract NameResolver getResolver();

    protected abstract ValueFactory getValueFactory();

    protected abstract PrivilegeManagerImpl getPrivilegeManager();

    protected int buildHashCode() {
        int h = 17;
        h = 37 * h + this.principal.getName().hashCode();
        h = 37 * h + this.privilegeBits.hashCode();
        h = 37 * h + Boolean.valueOf(this.allow).hashCode();
        h = 37 * h + ((Object)this.restrictions).hashCode();
        return h;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Privilege[] getPrivileges() {
        if (this.privileges == null) {
            Set<Privilege> ps = this.getPrivilegeManager().getPrivileges(this.privilegeBits);
            this.privileges = ps.toArray(new Privilege[ps.size()]);
        }
        return this.privileges;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public String[] getRestrictionNames() throws NamespaceException {
        String[] restrNames = new String[this.restrictions.size()];
        int i = 0;
        for (Name n : this.restrictions.keySet()) {
            restrNames[i] = this.getResolver().getJCRName(n);
            ++i;
        }
        return restrNames;
    }

    public Value getRestriction(String restrictionName) throws RepositoryException {
        return this.getRestriction(this.getResolver().getQName(restrictionName));
    }

    public Value[] getRestrictions(String restrictionName) throws RepositoryException {
        return new Value[]{this.getRestriction(restrictionName)};
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.buildHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlEntryImpl) {
            AccessControlEntryImpl other = (AccessControlEntryImpl)obj;
            return this.principal.getName().equals(other.principal.getName()) && this.privilegeBits.equals(other.privilegeBits) && this.allow == other.allow && ((Object)this.restrictions).equals(other.restrictions);
        }
        return false;
    }
}

