/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs;

import java.io.ByteArrayOutputStream;
import java.util.BitSet;
import org.apache.jackrabbit.core.fs.FileSystemException;

public final class FileSystemPathUtil {
    private static final char[] HEX_TABLE;
    private static final char ESCAPE_CHAR = '%';
    public static final BitSet SAFE_NAMECHARS;
    public static final BitSet SAFE_PATHCHARS;

    private FileSystemPathUtil() {
    }

    private static String escape(String s, BitSet safeChars) {
        byte[] bytes = s.getBytes();
        StringBuilder out = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            if (safeChars.get(c) && c != 37) {
                out.append((char)c);
                continue;
            }
            out.append('%');
            out.append(HEX_TABLE[c >> 4 & 0xF]);
            out.append(HEX_TABLE[c & 0xF]);
        }
        return out.toString();
    }

    public static String escapePath(String path) {
        return FileSystemPathUtil.escape(path, SAFE_PATHCHARS);
    }

    public static String escapeName(String name) {
        return FileSystemPathUtil.escape(name, SAFE_NAMECHARS);
    }

    public static String unescape(String pathOrName) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(pathOrName.length());
        for (int i = 0; i < pathOrName.length(); ++i) {
            char c = pathOrName.charAt(i);
            if (c == '%') {
                try {
                    out.write(Integer.parseInt(pathOrName.substring(i + 1, i + 3), 16));
                }
                catch (NumberFormatException e) {
                    IllegalArgumentException iae = new IllegalArgumentException("Failed to unescape escape sequence");
                    iae.initCause(e);
                    throw iae;
                }
                i += 2;
                continue;
            }
            out.write(c);
        }
        return new String(out.toByteArray());
    }

    public static boolean denotesRoot(String path) {
        return path.equals("/");
    }

    public static void checkFormat(String path) throws FileSystemException {
        if (path == null) {
            throw new FileSystemException("null path");
        }
        if (!path.startsWith("/")) {
            throw new FileSystemException("not an absolute path: " + path);
        }
        if (path.endsWith("/") && path.length() > 1) {
            throw new FileSystemException("malformed path: " + path);
        }
        String[] names = path.split("/");
        for (int i = 1; i < names.length; ++i) {
            if (names[i].length() == 0) {
                throw new FileSystemException("empty name: " + path);
            }
            String trimmed = names[i].trim();
            if (trimmed.equals(names[i])) continue;
            throw new FileSystemException("illegal leading or trailing whitespace in name: " + path);
        }
    }

    public static String getParentDir(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        return "/";
    }

    public static String getName(String path) {
        int pos = path.lastIndexOf(47);
        if (pos != -1) {
            return path.substring(pos + 1);
        }
        return path;
    }

    static {
        int i;
        HEX_TABLE = "0123456789abcdef".toCharArray();
        SAFE_NAMECHARS = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            SAFE_NAMECHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            SAFE_NAMECHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            SAFE_NAMECHARS.set(i);
        }
        SAFE_NAMECHARS.set(45);
        SAFE_NAMECHARS.set(95);
        SAFE_NAMECHARS.set(46);
        SAFE_PATHCHARS = (BitSet)SAFE_NAMECHARS.clone();
        SAFE_PATHCHARS.set(47);
    }
}

