/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RandomInputStream
extends InputStream {
    private static final long MUL = 25214903917L;
    private static final long ADD = 11L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static final int DEFAULT_MAX_READ_BLOCK_SIZE = 15;
    private final long initialSeed;
    private final long len;
    private long markedState;
    private long pos;
    private long markedPos;
    private long state;
    private int maxReadBlockSize;

    public String toString() {
        return "new RandomInputStream(" + this.initialSeed + ", " + this.len + ")";
    }

    public RandomInputStream(long seed, long len) {
        this(seed, len, 15);
    }

    public static void compareStreams(InputStream a, InputStream b) throws IOException {
        block1: {
            int y;
            int x;
            a = new BufferedInputStream(a);
            b = new BufferedInputStream(b);
            long pos = 0L;
            do {
                x = a.read();
                y = b.read();
                if ((x == -1 || y == -1) && x == y) break block1;
            } while (x == y);
            throw new IOException("Incorrect byte at position " + pos + ": x=" + x + " y=" + y);
        }
    }

    public RandomInputStream(long seed, long len, int maxReadBlockSize) {
        this.initialSeed = seed;
        this.len = len;
        this.maxReadBlockSize = maxReadBlockSize;
        this.setSeed(seed);
        this.reset();
    }

    @Override
    public long skip(long n) {
        if ((n = (long)this.getReadBlock(n)) == 0L) {
            return -1L;
        }
        this.pos += n;
        return n;
    }

    private int getReadBlock(long n) {
        if (n > this.len - this.pos) {
            n = this.len - this.pos;
        }
        if (n > (long)this.maxReadBlockSize) {
            n = this.maxReadBlockSize;
        } else if (n < 0L) {
            n = 0L;
        }
        return (int)n;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.len) {
            return -1;
        }
        if ((len = this.getReadBlock(len)) == 0) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            b[off + i] = (byte)(this.next() & 0xFF);
        }
        this.pos += (long)len;
        return len;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() {
        this.pos = this.len;
    }

    private void setSeed(long seed) {
        this.markedState = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    private int next() {
        this.state = this.state * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.state >>> 16);
    }

    @Override
    public void reset() {
        this.pos = this.markedPos;
        this.state = this.markedState;
    }

    @Override
    public int read() {
        if (this.pos >= this.len) {
            return -1;
        }
        ++this.pos;
        return this.next() & 0xFF;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markedPos = this.pos;
        this.markedState = this.state;
    }
}

