/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public final class JCARepositoryManager {
    public static final String CLASSPATH_CONFIG_PREFIX = "classpath:";
    private static final JCARepositoryManager INSTANCE = new JCARepositoryManager();
    private final Map references = new HashMap();
    private boolean autoShutdown = true;

    private JCARepositoryManager() {
    }

    public RepositoryImpl createRepository(String homeDir, String configFile) throws RepositoryException {
        Reference ref = this.getReference(homeDir, configFile);
        return ref.create();
    }

    public void shutdown() {
        Collection references = this.references.values();
        for (Reference ref : references) {
            ref.shutdown();
        }
        this.references.clear();
    }

    private synchronized Reference getReference(String homeDir, String configFile) {
        Reference ref = new Reference(homeDir, configFile);
        Reference other = (Reference)this.references.get(ref);
        if (other == null) {
            this.references.put(ref, ref);
            return ref;
        }
        return other;
    }

    public static JCARepositoryManager getInstance() {
        return INSTANCE;
    }

    public boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    public void setAutoShutdown(boolean autoShutdown) {
        this.autoShutdown = autoShutdown;
    }

    public void autoShutdownRepository(String homeDir, String configFile) {
        if (this.isAutoShutdown()) {
            Reference ref = this.getReference(homeDir, configFile);
            ref.shutdown();
        }
    }

    private final class Reference {
        private final String homeDir;
        private String configFile;
        private RepositoryImpl repository;

        private Reference(String homeDir, String configFile) {
            this.homeDir = homeDir;
            this.configFile = configFile;
            this.repository = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RepositoryImpl create() throws RepositoryException {
            if (this.repository == null) {
                RepositoryConfig config = null;
                if (this.configFile.startsWith(JCARepositoryManager.CLASSPATH_CONFIG_PREFIX)) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = this.getClass().getClassLoader();
                    }
                    InputStream configInputStream = cl.getResourceAsStream(this.configFile.substring(JCARepositoryManager.CLASSPATH_CONFIG_PREFIX.length()));
                    try {
                        config = RepositoryConfig.create((InputStream)configInputStream, (String)this.homeDir);
                    }
                    finally {
                        if (configInputStream != null) {
                            try {
                                configInputStream.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                config = RepositoryConfig.create((String)this.configFile, (String)this.homeDir);
                this.repository = RepositoryImpl.create((RepositoryConfig)config);
            }
            return this.repository;
        }

        public void shutdown() {
            if (this.repository != null) {
                this.repository.shutdown();
            }
        }

        public int hashCode() {
            int result = this.homeDir != null ? this.homeDir.hashCode() : 0;
            result = 37 * result + (this.configFile != null ? this.configFile.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Reference) {
                return this.equals((Reference)o);
            }
            return false;
        }

        private boolean equals(Reference o) {
            return this.equals(this.homeDir, o.homeDir) && this.equals(this.configFile, o.configFile);
        }

        private boolean equals(String s1, String s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }
    }
}

