/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons.jackrabbit.authorization;

import java.security.Principal;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

public class AccessControlUtils {
    public static Privilege[] privilegesFromNames(Session session, String ... privilegeNames) throws RepositoryException {
        return AccessControlUtils.privilegesFromNames(session.getAccessControlManager(), privilegeNames);
    }

    public static Privilege[] privilegesFromNames(AccessControlManager accessControlManager, String ... privilegeNames) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>(privilegeNames.length);
        for (String privName : privilegeNames) {
            privileges.add(accessControlManager.privilegeFromName(privName));
        }
        return privileges.toArray(new Privilege[privileges.size()]);
    }

    public static String[] namesFromPrivileges(Privilege ... privileges) {
        if (privileges == null || privileges.length == 0) {
            return new String[0];
        }
        String[] names = new String[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            names[i] = privileges[i].getName();
        }
        return names;
    }

    public static JackrabbitAccessControlList getAccessControlList(Session session, String absPath) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        return AccessControlUtils.getAccessControlList(acMgr, absPath);
    }

    public static JackrabbitAccessControlList getAccessControlList(AccessControlManager accessControlManager, String absPath) throws RepositoryException {
        AccessControlPolicy[] pcls;
        AccessControlPolicyIterator itr = accessControlManager.getApplicablePolicies(absPath);
        while (itr.hasNext()) {
            AccessControlPolicy policy = itr.nextAccessControlPolicy();
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        for (AccessControlPolicy policy : pcls = accessControlManager.getPolicies(absPath)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        return null;
    }

    public static boolean addAccessControlEntry(Session session, String absPath, Principal principal, String[] privilegeNames, boolean isAllow) throws RepositoryException {
        return AccessControlUtils.addAccessControlEntry(session, absPath, principal, AccessControlUtils.privilegesFromNames(session, privilegeNames), isAllow);
    }

    public static boolean addAccessControlEntry(Session session, String absPath, Principal principal, Privilege[] privileges, boolean isAllow) throws RepositoryException {
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(session, absPath);
        if (acl != null && acl.addEntry(principal, privileges, isAllow)) {
            session.getAccessControlManager().setPolicy(absPath, (AccessControlPolicy)acl);
            return true;
        }
        return false;
    }

    public static boolean grantAllToEveryone(Session session, String absPath) throws RepositoryException {
        Principal everyone = AccessControlUtils.getEveryonePrincipal(session);
        Privilege[] privileges = AccessControlUtils.privilegesFromNames(session, "{http://www.jcp.org/jcr/1.0}all");
        return AccessControlUtils.addAccessControlEntry(session, absPath, everyone, privileges, true);
    }

    public static boolean denyAllToEveryone(Session session, String absPath) throws RepositoryException {
        Principal everyone = AccessControlUtils.getEveryonePrincipal(session);
        Privilege[] privileges = AccessControlUtils.privilegesFromNames(session, "{http://www.jcp.org/jcr/1.0}all");
        return AccessControlUtils.addAccessControlEntry(session, absPath, everyone, privileges, false);
    }

    private static Principal getEveryonePrincipal(Session session) throws RepositoryException {
        if (session instanceof JackrabbitSession) {
            return ((JackrabbitSession)session).getPrincipalManager().getEveryone();
        }
        throw new UnsupportedOperationException("Failed to retrieve everyone principal: JackrabbitSession expected.");
    }
}

