/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.AbstractValue;

class DecimalValue
extends AbstractValue {
    private static final long serialVersionUID = 2077767642124007133L;
    private static final BigDecimal MIN_DATE = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_DATE = BigDecimal.valueOf(Long.MAX_VALUE);
    private final BigDecimal value;

    public DecimalValue(BigDecimal value) {
        this.value = value;
    }

    public int getType() {
        return 12;
    }

    public Calendar getDate() throws ValueFormatException {
        if (this.value.compareTo(MIN_DATE) >= 0 && this.value.compareTo(MAX_DATE) <= 0) {
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(this.getLong());
            return date;
        }
        throw new ValueFormatException("Decimal value is outside the date range: " + this.value);
    }

    public BigDecimal getDecimal() {
        return this.value;
    }

    public double getDouble() {
        return this.value.doubleValue();
    }

    public long getLong() {
        return this.value.longValue();
    }

    public String getString() {
        return this.value.toString();
    }
}

