/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteLock;

public class ClientLock
extends ClientObject
implements Lock {
    private Session session;
    private RemoteLock remote;

    public ClientLock(Session session, RemoteLock remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public Node getNode() {
        try {
            return this.getNode(this.session, this.remote.getNode());
        }
        catch (RemoteException e) {
            throw new RemoteRuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLockOwner() {
        try {
            return this.remote.getLockOwner();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isDeep() {
        try {
            return this.remote.isDeep();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String getLockToken() {
        try {
            return this.remote.getLockToken();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isLive() throws RepositoryException {
        try {
            return this.remote.isLive();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public void refresh() throws RepositoryException {
        try {
            this.remote.refresh();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean isSessionScoped() {
        try {
            return this.remote.isSessionScoped();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public long getSecondsRemaining() throws RepositoryException {
        try {
            return this.remote.getSecondsRemaining();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isLockOwningSession() {
        try {
            return this.remote.isLockOwningSession();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

