/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.repository;

import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.repository.AbstractRemoteRepositoryFactory;

public class JNDIRemoteRepositoryFactory
extends AbstractRemoteRepositoryFactory {
    private final Context context;
    private final String location;

    public JNDIRemoteRepositoryFactory(LocalAdapterFactory factory, Context context, String location) {
        super(factory);
        this.context = context;
        this.location = location;
    }

    @Override
    protected RemoteRepository getRemoteRepository() throws RepositoryException {
        try {
            Object remote = this.context.lookup(this.location);
            if (remote instanceof RemoteRepository) {
                return (RemoteRepository)remote;
            }
            if (remote == null) {
                throw new RepositoryException("Remote repository not found: The JNDI entry " + this.location + " is null");
            }
            throw new RepositoryException("Invalid remote repository: The JNDI entry " + this.location + " is an instance of " + remote.getClass().getName());
        }
        catch (NamingException e) {
            throw new RepositoryException("Remote repository not found: The JNDI entry " + this.location + " could not be looked up", (Throwable)e);
        }
    }
}

