/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.jcr.Item;
import org.apache.jackrabbit.server.io.DefaultIOListener;
import org.apache.jackrabbit.server.io.IOListener;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportContextImpl
implements ImportContext {
    private static Logger log = LoggerFactory.getLogger((Class)ImportContextImpl.class);
    private final IOListener ioListener;
    private final Item importRoot;
    private final String systemId;
    private final File inputFile;
    private InputContext inputCtx;
    private boolean completed;

    public ImportContextImpl(Item importRoot, String systemId, InputContext inputCtx) throws IOException {
        this(importRoot, systemId, inputCtx != null ? inputCtx.getInputStream() : null, null);
        this.inputCtx = inputCtx;
    }

    public ImportContextImpl(Item importRoot, String systemId, InputStream in, IOListener ioListener) throws IOException {
        this.importRoot = importRoot;
        this.systemId = systemId;
        this.inputFile = IOUtil.getTempFile(in);
        this.ioListener = ioListener != null ? ioListener : new DefaultIOListener(log);
    }

    public IOListener getIOListener() {
        return this.ioListener;
    }

    public Item getImportRoot() {
        return this.importRoot;
    }

    public boolean hasStream() {
        return this.inputFile != null;
    }

    public InputStream getInputStream() {
        this.checkCompleted();
        FileInputStream in = null;
        if (this.inputFile != null) {
            try {
                in = new FileInputStream(this.inputFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return in;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public long getModificationTime() {
        return this.inputCtx != null ? this.inputCtx.getModificationTime() : new Date().getTime();
    }

    public String getContentLanguage() {
        return this.inputCtx != null ? this.inputCtx.getContentLanguage() : null;
    }

    public long getContentLength() {
        return this.inputCtx != null ? this.inputCtx.getContentLength() : -1L;
    }

    private String getContentType() {
        return this.inputCtx != null ? this.inputCtx.getContentType() : null;
    }

    public String getMimeType() {
        String contentType = this.getContentType();
        String mimeType = null;
        if (contentType != null) {
            mimeType = IOUtil.getMimeType(contentType);
        } else if (this.getSystemId() != null) {
            mimeType = IOUtil.MIME_RESOLVER.getMimeType(this.getSystemId());
        }
        return mimeType;
    }

    public String getEncoding() {
        String contentType = this.getContentType();
        return contentType != null ? IOUtil.getEncoding(contentType) : null;
    }

    public Object getProperty(Object propertyName) {
        return this.inputCtx != null ? this.inputCtx.getProperty(propertyName.toString()) : null;
    }

    public void informCompleted(boolean success) {
        this.checkCompleted();
        this.completed = true;
        if (this.inputFile != null) {
            this.inputFile.delete();
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private void checkCompleted() {
        if (this.completed) {
            throw new IllegalStateException("ImportContext has already been consumed.");
        }
    }
}

