/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.remote;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import org.apache.jackrabbit.servlet.remote.RemoteBindingServlet;

public class RMIRemoteBindingServlet
extends RemoteBindingServlet {
    private static final long serialVersionUID = 1627580747678104906L;
    private String url;

    public void init() throws ServletException {
        this.url = this.getInitParameter("url");
        if (this.url == null) {
            this.url = "//localhost/javax/jcr/Repository";
        }
        try {
            Naming.rebind(this.url, (Remote)this.getRemoteRepository());
        }
        catch (MalformedURLException e) {
            this.log("Invalid RMI URL: " + this.url, e);
        }
        catch (RemoteException e) {
            this.log("Failed to bind repository to RMI: " + this.url, e);
        }
    }

    public void destroy() {
        try {
            Naming.unbind(this.url);
        }
        catch (NotBoundException e) {
        }
        catch (MalformedURLException e) {
        }
        catch (RemoteException e) {
            this.log("Failed to unbind repository from RMI: " + this.url, e);
        }
    }
}

