/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeUUIDTest
extends AbstractJCRTest {
    public void testSaveReferentialIntegrityException() throws RepositoryException, NotExecutableException {
        this.checkMixReferenceable();
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node referencingNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node refTargetNode = defaultRootNode.addNode(this.nodeName2, this.getProperty("nodetype2"));
        defaultRootNode.save();
        this.ensureCanSetProperty(referencingNode, this.propertyName1, referencingNode.getSession().getValueFactory().createValue(refTargetNode));
        referencingNode.setProperty(this.propertyName1, refTargetNode);
        defaultRootNode.save();
        refTargetNode.remove();
        try {
            defaultRootNode.save();
            NodeUUIDTest.fail((String)"Saving a deleted node using Node.save() that is a reference target should throw ReferentialIntegrityException");
        }
        catch (ReferentialIntegrityException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveMovedRefNode() throws RepositoryException, NotExecutableException {
        this.checkMixReferenceable();
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node newParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node refTargetNode = defaultRootNode.addNode(this.nodeName2, this.getProperty("nodetype2"));
        this.superuser.save();
        Session testSession = helper.getReadWriteSession();
        try {
            Node refTargetNodeSession2 = (Node)testSession.getItem(refTargetNode.getPath());
            this.superuser.move(refTargetNode.getPath(), newParentNode.getPath() + "/" + this.nodeName3);
            this.superuser.save();
            try {
                refTargetNodeSession2.setProperty(this.propertyName1, "test");
                refTargetNodeSession2.save();
            }
            catch (InvalidItemStateException e) {
                // empty catch block
            }
        }
        finally {
            testSession.logout();
        }
    }

    private void checkMixReferenceable() throws RepositoryException, NotExecutableException {
        try {
            this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.mixReferenceable);
        }
        catch (NoSuchNodeTypeException e) {
            throw new NotExecutableException("Repository does not support mix:referenceable");
        }
    }
}

