/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SetPropertyInputStreamTest
extends AbstractJCRTest {
    private Node testNode;
    byte[] bytes1 = new byte[]{73, 26, 32, -36, 40, -43, -124};
    private InputStream is1 = new ByteArrayInputStream(this.bytes1);
    byte[] bytes2 = new byte[]{-124, -43, 40, -36, 32, 26, 73};
    private InputStream is2 = new ByteArrayInputStream(this.bytes2);

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        if (this.propertyName1.equals("jcr:data") && this.testNode.hasNode("jcr:content") && this.testNode.getNode("jcr:content").isNodeType("nt:resource") && !this.testNode.hasProperty("jcr:data")) {
            this.testNode = this.testNode.getNode("jcr:content");
        }
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewInputStreamPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.is1);
        this.superuser.save();
        this.is1 = new ByteArrayInputStream(this.bytes1);
        InputStream in = this.testNode.getProperty(this.propertyName1).getStream();
        try {
            SetPropertyInputStreamTest.assertTrue((String)"Setting property with Node.setProperty(String, InputStream) and Session.save() not working", (boolean)this.compareInputStreams(this.is1, in));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyInputStreamPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.is1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.is2);
        this.superuser.save();
        this.is2 = new ByteArrayInputStream(this.bytes2);
        InputStream in = this.testNode.getProperty(this.propertyName1).getStream();
        try {
            SetPropertyInputStreamTest.assertTrue((String)"Modifying property with Node.setProperty(String, InputStream) and Session.save() not working", (boolean)this.compareInputStreams(this.is2, in));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewInputStreamPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.is1);
        this.testRootNode.save();
        this.is1 = new ByteArrayInputStream(this.bytes1);
        InputStream in = this.testNode.getProperty(this.propertyName1).getStream();
        try {
            SetPropertyInputStreamTest.assertTrue((String)"Setting property with Node.setProperty(String, InputStream) and parentNode.save() not working", (boolean)this.compareInputStreams(this.is1, in));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyInputStreamPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.is1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, this.is2);
        this.testRootNode.save();
        this.is2 = new ByteArrayInputStream(this.bytes2);
        InputStream in = this.testNode.getProperty(this.propertyName1).getStream();
        try {
            SetPropertyInputStreamTest.assertTrue((String)"Modifying property with Node.setProperty(String, InputStream) and parentNode.save() not working", (boolean)this.compareInputStreams(this.is2, in));
        }
        finally {
            in.close();
        }
    }

    public void testRemoveInputStreamPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.is1);
        this.superuser.save();
        Property property = this.testNode.getProperty(this.propertyName1);
        if (property.getDefinition().isMandatory() || property.getDefinition().isProtected()) {
            throw new NotExecutableException("property " + property.getName() + " can not be removed");
        }
        this.testNode.setProperty(this.propertyName1, (InputStream)null);
        this.superuser.save();
        SetPropertyInputStreamTest.assertFalse((String)"Removing property with Node.setProperty(String, (InputStream)null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveInputStreamPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.is1);
        this.testRootNode.save();
        Property property = this.testNode.getProperty(this.propertyName1);
        if (property.getDefinition().isMandatory() || property.getDefinition().isProtected()) {
            throw new NotExecutableException("property " + property.getName() + " can not be removed");
        }
        this.testNode.setProperty(this.propertyName1, (InputStream)null);
        this.testRootNode.save();
        SetPropertyInputStreamTest.assertFalse((String)"Removing property with Node.setProperty(String, (InputStream)null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    private boolean compareInputStreams(InputStream f1, InputStream f2) {
        try {
            int f2byte;
            int f1byte;
            boolean equal = false;
            while ((f1byte = f1.read()) != -1) {
                f2byte = f2.read();
                if (f2byte != -1 && f2byte == f1byte) {
                    equal = true;
                    continue;
                }
                equal = false;
                break;
            }
            if ((f2byte = f2.read()) != -1) {
                equal = false;
            }
            return equal;
        }
        catch (Exception e) {
            return false;
        }
    }
}

