/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class LockingTest
extends AbstractObservationTest {
    public void testAddLockToNode() throws RepositoryException {
        Node lockable = this.createLockable(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 4);
        lockable.lock(false, true);
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        LockingTest.assertEquals((String)"Wrong number of events.", (int)2, (int)events.length);
        for (int i = 0; i < events.length; ++i) {
            LockingTest.assertEquals((String)"Wrong type of event.", (int)4, (int)events[i].getType());
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < events.length; ++i) {
            paths.add(events[i].getPath());
        }
        String lockOwnerPath = this.testRoot + "/" + this.nodeName1 + "/" + this.jcrLockOwner;
        LockingTest.assertTrue((String)"No event created for jcr:lockOwner", (boolean)paths.contains(lockOwnerPath));
        String lockIsDeepPath = this.testRoot + "/" + this.nodeName1 + "/" + this.jcrlockIsDeep;
        LockingTest.assertTrue((String)"No event created for jcr:lockIsDeep", (boolean)paths.contains(lockIsDeepPath));
        lockable.unlock();
    }

    public void testRemoveLockFromNode() throws RepositoryException {
        Node lockable = this.createLockable(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        lockable.lock(false, true);
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 8);
        lockable.unlock();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        LockingTest.assertEquals((String)"Wrong number of events.", (int)2, (int)events.length);
        for (int i = 0; i < events.length; ++i) {
            LockingTest.assertEquals((String)"Wrong type of event.", (int)8, (int)events[i].getType());
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < events.length; ++i) {
            paths.add(events[i].getPath());
        }
        String lockOwnerPath = this.testRoot + "/" + this.nodeName1 + "/" + this.jcrLockOwner;
        LockingTest.assertTrue((String)"No event created for jcr:lockOwner", (boolean)paths.contains(lockOwnerPath));
        String lockIsDeepPath = this.testRoot + "/" + this.nodeName1 + "/" + this.jcrlockIsDeep;
        LockingTest.assertTrue((String)"No event created for jcr:lockIsDeep", (boolean)paths.contains(lockIsDeepPath));
    }

    private Node createLockable(String nodeName, String nodeType) throws RepositoryException {
        Node n = this.testRootNode.addNode(nodeName, nodeType);
        if (this.needsMixin(n, this.mixLockable)) {
            n.addMixin(this.mixLockable);
        }
        return n;
    }
}

