/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeNodeTest
extends AbstractMergeTest {
    Node nodeToMerge;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        this.nodeToMerge.checkout();
    }

    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void testMergeNodeWithUnsavedStates() throws RepositoryException {
        this.nodeToMerge.setProperty(this.propertyName1, "changed");
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"InvalidItemStateException if unsaved changes within the current Session was expected.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testMergeUnknownWorkspaceName() throws RepositoryException {
        try {
            this.nodeToMerge.merge(this.getNonExistingWorkspaceName(this.superuser), false);
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testMergeNodeNonCorrespondingNode() throws RepositoryException {
        Node subNode = this.nodeToMerge.addNode(this.nodeName3, this.versionableNodeType);
        subNode.setProperty(this.propertyName1, "changed");
        this.superuserW2.save();
        subNode.checkin();
        subNode.merge(this.workspace.getName(), true);
        MergeNodeTest.assertTrue((boolean)subNode.getProperty(this.propertyName1).getString().equals("changed"));
    }

    public void testMergeNodeVersionAmbiguous() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        try {
            this.nodeToMerge.checkout();
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"Node has ambigous versions. Merge must throw a MergeException");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortTrueCheckMergeFailedProperty() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        String expectedReferenceUUID = originalNode.getBaseVersion().getUUID();
        Property mergeFailedProperty = this.nodeToMerge.getProperty(this.jcrMergeFailed);
        Value[] references = mergeFailedProperty.getValues();
        boolean referenceFound = false;
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                String referenceUUID = references[i].getString();
                if (!referenceUUID.equals(expectedReferenceUUID)) continue;
                referenceFound = true;
                break;
            }
            MergeNodeTest.assertTrue((String)"reference to expected version that give the failure wasnt found in the mergeFailed", (boolean)referenceFound);
        }
    }

    public void disable_testMergeNodeForceFailure() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        try {
            this.nodeToMerge.merge(this.workspace.getName(), true);
            MergeNodeTest.fail((String)"Merge failed for node in earlier merge operations. Because the mergeFailedProperty is present, merge must throw a VersionException");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortFalse() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"bestEffort is false and any merge should throw a MergeException.");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortFalseAmbiguousVersions() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"BestEffort is false and corresponding node's version is ambiguous. Merge should throw a MergeException.");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable_testMergeLocked() throws NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        if (!this.nodeToMerge.isNodeType(this.mixLockable)) {
            if (this.nodeToMerge.canAddMixin(this.mixLockable)) {
                this.nodeToMerge.addMixin(this.mixLockable);
            } else {
                throw new NotExecutableException("Node " + this.nodeToMerge.getName() + " is not lockable and " + "does not allow to add mix:lockable");
            }
        }
        this.nodeToMerge.getParent().save();
        String pathRelToRoot = this.nodeToMerge.getPath().substring(1);
        Session session2 = helper.getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(false, false);
            try {
                this.nodeToMerge.merge(this.workspace.getName(), false);
                MergeNodeTest.fail((String)"merge must throw a LockException if applied on a locked node");
            }
            catch (LockException e) {
                // empty catch block
            }
            node2.unlock();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            session2.logout();
            throw throwable;
        }
        session2.logout();
    }

    protected void initNodes() throws RepositoryException {
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        this.testRootNode.save();
        topVNode.checkin();
        topVNode.checkout();
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }
}

