/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;

public class LogPrintWriter
extends PrintWriter {
    private StringBuffer buffer = new StringBuffer();
    private Logger log;

    public LogPrintWriter(Writer out) {
        super(out);
    }

    public LogPrintWriter(Logger log) {
        super(new NullWriter());
        this.log = log;
    }

    public void setWriter(Writer out) {
        this.flushBuffer();
        this.out = out;
        this.log = null;
    }

    public void setLogger(Logger log) {
        this.flushBuffer();
        this.out = new NullWriter();
        this.log = log;
    }

    public void close() {
        this.flushBuffer();
        super.close();
    }

    public void flush() {
        this.flushBuffer();
        super.flush();
    }

    public void write(int c) {
        this.buffer.append(c);
    }

    public void write(char[] cbuf, int off, int len) {
        this.buffer.append(cbuf, off, len);
    }

    public void write(String str, int off, int len) {
        this.buffer.append(str.substring(off, off + len));
    }

    public void println() {
        if (this.log == null) {
            this.buffer.append('\n');
        }
        this.flushBuffer();
    }

    private void flushBuffer() {
        if (this.buffer.length() == 0) {
            return;
        }
        if (this.log != null) {
            this.log.debug(this.buffer.toString());
        } else {
            try {
                this.out.write(this.buffer.toString());
            }
            catch (IOException e) {
                this.setError();
            }
        }
        this.buffer.setLength(0);
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }
    }
}

