/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyTest;

abstract class AbstractWorkspaceCopyBetweenTest
extends AbstractWorkspaceCopyTest {
    protected Session superuserW2;
    protected Session rwSessionW2;
    Workspace workspaceW2;
    Node testRootNodeW2;
    protected Node node1W2;
    protected Node node2W2;

    AbstractWorkspaceCopyBetweenTest() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        String otherWspName = this.getOtherWorkspaceName();
        this.superuserW2 = this.getHelper().getSuperuserSession(otherWspName);
        this.rwSessionW2 = this.getHelper().getReadWriteSession(otherWspName);
        this.workspaceW2 = this.superuserW2.getWorkspace();
        this.initNodesW2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        if (this.superuserW2 != null) {
            try {
                if (!this.isReadOnly) {
                    this.cleanUpTestRoot(this.superuserW2);
                }
            }
            finally {
                this.superuserW2.logout();
                this.superuserW2 = null;
            }
        }
        if (this.rwSessionW2 != null) {
            this.rwSessionW2.logout();
            this.rwSessionW2 = null;
        }
        this.workspaceW2 = null;
        this.testRootNodeW2 = null;
        this.node1W2 = null;
        this.node2W2 = null;
        super.tearDown();
    }

    protected String getOtherWorkspaceName() throws NotExecutableException {
        if (this.workspace.getName().equals(this.workspaceName)) {
            throw new NotExecutableException("Cannot test copy between workspaces. 'workspaceName' points to default workspace as well.");
        }
        return this.workspaceName;
    }

    protected void initNodesW2() throws RepositoryException {
        if (this.superuserW2.getRootNode().hasNode(this.testPath)) {
            this.testRootNodeW2 = this.superuserW2.getRootNode().getNode(this.testPath);
            NodeIterator it = this.testRootNodeW2.getNodes();
            while (it.hasNext()) {
                it.nextNode().remove();
            }
            this.testRootNodeW2.save();
        } else {
            this.testRootNodeW2 = this.superuserW2.getRootNode().addNode(this.testPath, this.testNodeType);
            this.superuserW2.save();
        }
        this.superuserW2.getWorkspace().copy(this.workspace.getName(), this.node1.getPath(), this.node1.getPath());
        this.node1W2 = this.testRootNodeW2.getNode(this.node1.getName());
        this.superuserW2.getWorkspace().copy(this.workspace.getName(), this.node2.getPath(), this.node2.getPath());
        this.node2W2 = this.testRootNodeW2.getNode(this.node2.getName());
    }
}

