/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NamespaceRemappingTest
extends AbstractJCRTest {
    private Session session;
    private NamespaceRegistry nsr;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.nsr = this.session.getWorkspace().getNamespaceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            if (this.session != null) {
                this.session.logout();
                this.session = null;
            }
        }
        finally {
            this.nsr = null;
            super.tearDown();
        }
    }

    public void testNamespaceRemapping() throws RepositoryException {
        Property primaryTypeProp = this.session.getRootNode().getProperty(this.jcrPrimaryType);
        NodeType ntBaseType = this.session.getWorkspace().getNodeTypeManager().getNodeType(this.ntBase);
        String jcrPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(jcrPrefix, "http://www.jcp.org/jcr/1.0");
        String ntPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(ntPrefix, "http://www.jcp.org/jcr/nt/1.0");
        NamespaceRemappingTest.assertTrue((String)"Unable to retrieve property with new namespace prefix.", (boolean)this.session.getRootNode().getProperty(jcrPrefix + ":primaryType").isSame((Item)primaryTypeProp));
        NamespaceRemappingTest.assertEquals((String)"NodeType name does not use new namespace prefix.", (String)ntBaseType.getName(), (String)(ntPrefix + ":base"));
        String propval = this.session.getRootNode().getProperty(jcrPrefix + ":primaryType").getString();
        String primaryType = this.session.getRootNode().getPrimaryNodeType().getName();
        NamespaceRemappingTest.assertEquals((String)"Remapping of jcr prefix failed", (String)primaryType, (String)propval);
    }

    public void testAutomaticNewLocalPrefix() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>(Arrays.asList(this.session.getNamespacePrefixes()));
        prefixes.remove(this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0"));
        prefixes.remove(this.session.getNamespacePrefix("http://www.jcp.org/jcr/nt/1.0"));
        String before = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        this.session.setNamespacePrefix(before, "http://www.jcp.org/jcr/nt/1.0");
        String name = this.session.getProperty("/{http://www.jcp.org/jcr/1.0}primaryType").getName();
        int colon = name.indexOf(58);
        String after = name.substring(0, colon);
        NamespaceRemappingTest.assertFalse((String)"Automatically created new local prefix of a namespace must be different from the prefix that removed the mapping", (boolean)after.equals(before));
        NamespaceRemappingTest.assertFalse((String)"Automatically created new local prefix of a namespace must be different from those already present", (boolean)prefixes.contains(after));
        try {
            NamespaceRemappingTest.assertEquals((String)"The local namespace mappings must match the automatically created new prefix of a namespace", (String)after, (String)this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0"));
        }
        catch (NamespaceException e) {
            NamespaceRemappingTest.fail((String)"Automatically created new prefix must be included in the set of local namespace mappings");
        }
    }

    public void testExceptionOnUnknownPrefix() throws RepositoryException {
        String before = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        String after = before + "-changed";
        this.session.setNamespacePrefix(after, "http://www.jcp.org/jcr/1.0");
        try {
            this.session.propertyExists("/" + before + ":primaryType");
            NamespaceRemappingTest.fail((String)"A path with an unknown prefix must cause an exception to be thrown");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testInitialLocalNamespaceMappings() throws RepositoryException {
        String[] uris = this.nsr.getURIs();
        for (int i = 0; i < uris.length; ++i) {
            NamespaceRemappingTest.assertEquals((String)("The initial local namespace prefix of \"" + uris[i] + "\" must match the persistent registry mapping"), (String)this.nsr.getPrefix(uris[i]), (String)this.session.getNamespacePrefix(uris[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScopeOfLocalNamepaceMappings() throws RepositoryException {
        String before = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        String after = before + "-changed";
        this.session.setNamespacePrefix(after, "http://www.jcp.org/jcr/1.0");
        NamespaceRemappingTest.assertEquals((String)after, (String)this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0"));
        Session another = this.getHelper().getReadOnlySession();
        try {
            NamespaceRemappingTest.assertEquals((String)"Local namespace changes must not affect other sessions", (String)before, (String)another.getNamespacePrefix("http://www.jcp.org/jcr/1.0"));
        }
        finally {
            another.logout();
        }
    }

    public void testExceptionsFromRemapping() throws RepositoryException {
        this.assertSetNamespacePrefixFails("xml", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("xmlfoo", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("XML", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("XMLFOO", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("Xml", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("XmlFoo", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("", "http://www.jcp.org/jcr/1.0");
        this.assertSetNamespacePrefixFails("prefix", "");
    }

    private void assertSetNamespacePrefixFails(String prefix, String uri) throws RepositoryException {
        try {
            this.session.setNamespacePrefix(prefix, uri);
            NamespaceRemappingTest.fail((String)("Setting a local namespace mapping from \"" + prefix + "\" to \"" + uri + "\" must fail"));
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testGetNamespaceURI() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        String uri = this.session.getNamespaceURI(testPrefix);
        NamespaceRemappingTest.assertEquals((String)"Session.getNamespaceURI does not return the correct value.", (String)"http://www.jcp.org/jcr/1.0", (String)uri);
    }

    public void testGetNamespacePrefix() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        String prefix = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        NamespaceRemappingTest.assertEquals((String)"Session.getNamespacePrefix does not return the correct value.", (String)testPrefix, (String)prefix);
    }

    public void testGetNamespacePrefixes() throws RepositoryException {
        String testPrefix = this.getUnusedPrefix();
        this.session.setNamespacePrefix(testPrefix, "http://www.jcp.org/jcr/1.0");
        String[] prefixes = this.session.getNamespacePrefixes();
        NamespaceRemappingTest.assertEquals((String)"Session.getNamespacePrefixes() must return all prefixes currently set for this session.", (int)this.nsr.getPrefixes().length, (int)this.session.getNamespacePrefixes().length);
        String prefixNSR = this.nsr.getPrefix("http://www.jcp.org/jcr/1.0");
        for (int i = 0; i < prefixes.length; ++i) {
            if (!prefixes[i].equals(prefixNSR)) continue;
            NamespaceRemappingTest.fail((String)"Session.getNamespacePrefixes() must not return the prefixes over-ridden by Session.setNamespacePrefix");
        }
    }

    private String getUnusedPrefix() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.addAll(Arrays.asList(this.session.getNamespacePrefixes()));
        String prefix = "myapp";
        int count = 0;
        while (prefixes.contains(prefix + count)) {
            ++count;
        }
        return prefix + count;
    }
}

