/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class EventIteratorTest
extends AbstractObservationTest {
    public void testGetSize() throws RepositoryException, NotExecutableException {
        EventResult listener = new EventResult(this.log);
        this.addEventListener(listener, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        EventIterator events = listener.getEventIterator(5000L);
        this.removeEventListener(listener);
        EventIteratorTest.assertNotNull((String)"No events delivered within 5000ms.", (Object)events);
        long size = events.getSize();
        if (size == -1L) {
            throw new NotExecutableException("EventIterator.getSize() returns unavailable size.");
        }
        EventIteratorTest.assertEquals((String)"Wrong number of events", (long)1L, (long)size);
    }

    public void testGetPosition() throws RepositoryException {
        EventResult listener = new EventResult(this.log);
        this.addEventListener(listener, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        EventIterator events = listener.getEventIterator(5000L);
        this.removeEventListener(listener);
        EventIteratorTest.assertNotNull((String)"No events delivered within 5000ms.", (Object)events);
        EventIteratorTest.assertEquals((String)"Initial call to getPosition() must return 0.", (long)0L, (long)events.getPosition());
        events.nextEvent();
        EventIteratorTest.assertEquals((String)"Wrong value for getPosition()", (long)1L, (long)events.getPosition());
        events.nextEvent();
        EventIteratorTest.assertEquals((String)"Wrong value for getPosition()", (long)2L, (long)events.getPosition());
        events.nextEvent();
        EventIteratorTest.assertEquals((String)"Wrong value for getPosition()", (long)3L, (long)events.getPosition());
    }

    public void testSkip() throws RepositoryException {
        EventResult listener = new EventResult(this.log);
        this.addEventListener(listener, 1);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        EventIterator events = listener.getEventIterator(5000L);
        this.removeEventListener(listener);
        EventIteratorTest.assertNotNull((String)"No events delivered within 5000ms.", (Object)events);
        events.skip(0L);
        EventIteratorTest.assertEquals((String)"getPosition() for first element must return 0.", (long)0L, (long)events.getPosition());
        events.skip(2L);
        EventIteratorTest.assertEquals((String)"Wrong value for getPosition()", (long)2L, (long)events.getPosition());
        try {
            events.skip(2L);
            EventIteratorTest.fail((String)"EventIterator must throw NoSuchElementException when skipping past the end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

