/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public abstract class AbstractQueryLevel2Test
extends AbstractQueryTest {
    protected void setUpFullTextTest() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setProperty(this.propertyName1, "The quick brown fox jumps over the lazy dog.");
        node = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        node.setProperty(this.propertyName1, "The quick brown cat jumps over the lazy dog.");
        this.testRootNode.save();
    }

    protected void setUpRangeTest() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setProperty(this.propertyName1, "a");
        node = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        node.setProperty(this.propertyName1, "b");
        Node cNode = node.addNode(this.nodeName3, this.testNodeType);
        cNode.setProperty(this.propertyName1, "c");
        this.testRootNode.save();
    }

    protected void setUpMultiValueTest() throws RepositoryException, NotExecutableException {
        NodeType nt = this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.testNodeType);
        Value[] testValue = new Value[]{this.superuser.getValueFactory().createValue("one"), this.superuser.getValueFactory().createValue("two"), this.superuser.getValueFactory().createValue("three")};
        if (!nt.canSetProperty(this.propertyName2, testValue)) {
            throw new NotExecutableException("Property " + this.propertyName2 + " of NodeType " + this.testNodeType + " does not allow multi values");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setProperty(this.propertyName1, "existence");
        node.setProperty(this.propertyName2, testValue);
        node = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        node.setProperty(this.propertyName1, "nonexistence");
        node.setProperty(this.propertyName2, new String[]{"one", "three"});
        Node cNode = node.addNode(this.nodeName3, this.testNodeType);
        cNode.setProperty(this.propertyName1, "existence");
        this.testRootNode.save();
    }

    protected void checkValue(RowIterator itr, String propertyName, String expectedValue) throws RepositoryException {
        while (itr.hasNext()) {
            Row row = itr.nextRow();
            Value value = row.getValue(propertyName);
            if (value == null) {
                AbstractQueryLevel2Test.fail((String)"Search Test: fails result does not contain value for selected property");
            }
            AbstractQueryLevel2Test.assertEquals((String)"Value in query result row does not match expected value", (String)expectedValue, (String)value.getString());
        }
    }

    protected void checkValue(NodeIterator itr, String propertyName, String expectedValue) throws RepositoryException {
        while (itr.hasNext()) {
            Node node = itr.nextNode();
            Value value = node.getProperty(propertyName).getValue();
            AbstractQueryLevel2Test.assertEquals((String)"Value in query result row does not match expected value", (String)expectedValue, (String)value.getString());
        }
    }
}

