/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public abstract class AbstractOnParentVersionTest
extends AbstractVersionTest {
    protected int OPVAction;
    protected Property p;
    protected String initialPropValue = "initialValue";
    protected String newPropValue = "anotherValue";
    protected String childNodeTypeName;

    protected void setUp() throws Exception {
        super.setUp();
        this.childNodeTypeName = this.getProperty("nodetype");
        this.p = this.versionableNode.setProperty(this.propertyName1, this.initialPropValue);
        PropertyDefinition pd = this.p.getDefinition();
        if (pd.getOnParentVersion() != this.OPVAction) {
            AbstractOnParentVersionTest.fail((String)("JCR Property at '" + this.p.getPath() + "' does not have the required OnParentVersion " + OnParentVersionAction.nameFromValue((int)this.OPVAction) + " definition."));
        }
        this.testRootNode.save();
    }

    protected void tearDown() throws Exception {
        this.p = null;
        super.tearDown();
    }

    protected Node addChildNode(int requiredOpvBehaviour) throws RepositoryException {
        Node childNode;
        if (this.childNodeTypeName == null) {
            AbstractOnParentVersionTest.fail((String)("Undefined node type for the child node with OnParentVersion " + OnParentVersionAction.nameFromValue((int)requiredOpvBehaviour)));
        }
        if ((childNode = this.versionableNode.addNode(this.nodeName4, this.childNodeTypeName)).getDefinition().getOnParentVersion() != requiredOpvBehaviour) {
            AbstractOnParentVersionTest.fail((String)("The childnode " + childNode.getPath() + " does not provide the required OnParentVersion behaviour " + OnParentVersionAction.nameFromValue((int)requiredOpvBehaviour)));
        }
        return childNode;
    }
}

