/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeNodeTest
extends AbstractMergeTest {
    Node nodeToMerge;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        versionManager.checkout(this.nodeToMerge.getPath());
    }

    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void testMergeNodeWithUnsavedStates() throws RepositoryException {
        this.nodeToMerge.setProperty(this.propertyName1, "changed");
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"InvalidItemStateException if unsaved changes within the current Session was expected.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testMergeNodeWithUnsavedStatesJcr2() throws RepositoryException {
        this.nodeToMerge.setProperty(this.propertyName1, "changed");
        try {
            this.nodeToMerge.getSession().getWorkspace().getVersionManager().merge(this.nodeToMerge.getPath(), this.workspace.getName(), false);
            MergeNodeTest.fail((String)"InvalidItemStateException if unsaved changes within the current Session was expected.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testMergeUnknownWorkspaceName() throws RepositoryException {
        try {
            this.nodeToMerge.merge(this.getNonExistingWorkspaceName(this.superuser), false);
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testMergeUnknownWorkspaceNameJcr2() throws RepositoryException {
        try {
            this.nodeToMerge.getSession().getWorkspace().getVersionManager().merge(this.nodeToMerge.getPath(), this.getNonExistingWorkspaceName(this.superuser), false);
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testMergeNodeNonCorrespondingNode() throws RepositoryException {
        Node subNode = this.nodeToMerge.addNode(this.nodeName3, this.versionableNodeType);
        subNode.setProperty(this.propertyName1, "changed");
        this.superuserW2.save();
        subNode.checkin();
        subNode.merge(this.workspace.getName(), true);
        MergeNodeTest.assertTrue((boolean)subNode.getProperty(this.propertyName1).getString().equals("changed"));
    }

    public void testMergeNodeNonCorrespondingNodeJcr2() throws RepositoryException {
        Node subNode = this.nodeToMerge.addNode(this.nodeName3, this.versionableNodeType);
        subNode.setProperty(this.propertyName1, "changed");
        this.superuserW2.save();
        VersionManager versionManager = subNode.getSession().getWorkspace().getVersionManager();
        String path = subNode.getPath();
        versionManager.checkin(path);
        versionManager.merge(path, this.workspace.getName(), true);
        MergeNodeTest.assertTrue((boolean)subNode.getProperty(this.propertyName1).getString().equals("changed"));
    }

    public void testMergeNodeVersionAmbiguous() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        try {
            this.nodeToMerge.checkout();
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"Node has ambigous versions. Merge must throw a MergeException");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    public void testMergeNodeVersionAmbiguousJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager vmWsp1 = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        vmWsp1.checkout(originalPath);
        vmWsp1.checkin(originalPath);
        VersionManager vmWsp2 = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        vmWsp2.checkin(path);
        try {
            vmWsp2.checkout(path);
            vmWsp2.merge(path, this.workspace.getName(), false);
            MergeNodeTest.fail((String)"Node has ambigous versions. Merge must throw a MergeException");
        }
        catch (MergeException e) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortTrueCheckMergeFailedProperty() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        String expectedReferenceUUID = originalNode.getBaseVersion().getUUID();
        Property mergeFailedProperty = this.nodeToMerge.getProperty(this.jcrMergeFailed);
        Value[] references = mergeFailedProperty.getValues();
        boolean referenceFound = false;
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                String referenceUUID = references[i].getString();
                if (!referenceUUID.equals(expectedReferenceUUID)) continue;
                referenceFound = true;
                break;
            }
            MergeNodeTest.assertTrue((String)"reference to expected version that give the failure wasnt found in the mergeFailed", (boolean)referenceFound);
        }
    }

    public void testMergeNodeBestEffortTrueCheckMergeFailedPropertyJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager vmWsp1 = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        vmWsp1.checkout(originalPath);
        vmWsp1.checkin(originalPath);
        VersionManager vmWsp2 = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        vmWsp2.checkin(path);
        vmWsp2.checkout(path);
        vmWsp2.merge(path, this.workspace.getName(), true);
        String expectedReferenceUUID = originalNode.getBaseVersion().getUUID();
        Property mergeFailedProperty = this.nodeToMerge.getProperty(this.jcrMergeFailed);
        Value[] references = mergeFailedProperty.getValues();
        boolean referenceFound = false;
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                String referenceUUID = references[i].getString();
                if (!referenceUUID.equals(expectedReferenceUUID)) continue;
                referenceFound = true;
                break;
            }
            MergeNodeTest.assertTrue((String)"reference to expected version that give the failure wasnt found in the mergeFailed", (boolean)referenceFound);
        }
    }

    public void disable_testMergeNodeForceFailure() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        try {
            this.nodeToMerge.merge(this.workspace.getName(), true);
            MergeNodeTest.fail((String)"Merge failed for node in earlier merge operations. Because the mergeFailedProperty is present, merge must throw a VersionException");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void disable_testMergeNodeForceFailureJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager vmWsp1 = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        vmWsp1.checkout(originalPath);
        vmWsp1.checkin(originalPath);
        VersionManager vmWsp2 = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        vmWsp2.checkin(path);
        vmWsp2.checkout(path);
        vmWsp2.merge(path, this.workspace.getName(), true);
        try {
            vmWsp2.merge(path, this.workspace.getName(), true);
            MergeNodeTest.fail((String)"Merge failed for node in earlier merge operations. Because the mergeFailedProperty is present, merge must throw a VersionException");
        }
        catch (VersionException e) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortFalse() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"bestEffort is false and any merge should throw a MergeException.");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortFalseJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager vmWsp1 = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        vmWsp1.checkout(originalPath);
        vmWsp1.checkin(originalPath);
        try {
            this.nodeToMerge.getSession().getWorkspace().getVersionManager().merge(this.nodeToMerge.getPath(), this.workspace.getName(), false);
            MergeNodeTest.fail((String)"bestEffort is false and any merge should throw a MergeException.");
        }
        catch (MergeException e) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortFalseAmbiguousVersions() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeNodeTest.fail((String)"BestEffort is false and corresponding node's version is ambiguous. Merge should throw a MergeException.");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    public void testMergeNodeBestEffortFalseAmbiguousVersionsJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager vmWsp1 = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        vmWsp1.checkout(originalPath);
        vmWsp1.checkin(originalPath);
        VersionManager vmWsp2 = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        vmWsp2.checkin(path);
        vmWsp2.checkout(path);
        try {
            vmWsp2.merge(path, this.workspace.getName(), false);
            MergeNodeTest.fail((String)"BestEffort is false and corresponding node's version is ambiguous. Merge should throw a MergeException.");
        }
        catch (MergeException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable_testMergeLocked() throws NotExecutableException, RepositoryException {
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        this.ensureMixinType(this.nodeToMerge, this.mixLockable);
        this.nodeToMerge.getParent().save();
        String pathRelToRoot = this.nodeToMerge.getPath().substring(1);
        Session session2 = this.getHelper().getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(false, false);
            try {
                this.nodeToMerge.merge(this.workspace.getName(), false);
                MergeNodeTest.fail((String)"merge must throw a LockException if applied on a locked node");
            }
            catch (LockException e) {
                // empty catch block
            }
            node2.unlock();
        }
        finally {
            session2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable_testMergeLockedJcr2() throws NotExecutableException, RepositoryException {
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        this.ensureMixinType(this.nodeToMerge, this.mixLockable);
        this.nodeToMerge.getParent().getSession().save();
        String pathRelToRoot = this.nodeToMerge.getPath().substring(1);
        Session session2 = this.getHelper().getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.getSession().getWorkspace().getLockManager().lock(node2.getPath(), false, false, 60L, "");
            try {
                this.nodeToMerge.getSession().getWorkspace().getVersionManager().merge(this.nodeToMerge.getPath(), this.workspace.getName(), false);
                MergeNodeTest.fail((String)"merge must throw a LockException if applied on a locked node");
            }
            catch (LockException e) {
                // empty catch block
            }
            node2.getSession().getWorkspace().getLockManager().unlock(node2.getPath());
        }
        finally {
            session2.logout();
        }
    }

    protected void initNodes() throws RepositoryException {
        VersionManager versionManager = this.testRootNode.getSession().getWorkspace().getVersionManager();
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        String path = topVNode.getPath();
        this.testRootNode.getSession().save();
        versionManager.checkin(path);
        versionManager.checkout(path);
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }
}

