/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.lock;

import java.util.Arrays;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger((Class)LockManagerTest.class);
    protected LockManager lockMgr;
    protected Node testNode;
    protected String testPath;

    protected void setUp() throws Exception {
        super.setUp();
        if (Boolean.FALSE.toString().equals(this.superuser.getRepository().getDescriptor("option.locking.supported"))) {
            throw new NotExecutableException();
        }
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        this.testPath = this.testNode.getPath();
        this.lockMgr = LockManagerTest.getLockManager(this.superuser);
    }

    protected void tearDown() throws Exception {
        if (this.lockMgr != null && this.lockMgr.holdsLock(this.testPath)) {
            this.lockMgr.unlock(this.testPath);
        }
        super.tearDown();
    }

    private void assertLockable(Node n) throws RepositoryException, NotExecutableException {
        this.ensureMixinType(n, this.mixLockable);
        n.getSession().save();
    }

    private static LockManager getLockManager(Session session) throws RepositoryException {
        return session.getWorkspace().getLockManager();
    }

    private static boolean containsLockToken(LockManager lMgr, String token) throws RepositoryException {
        return LockManagerTest.containsLockToken(lMgr.getLockTokens(), token);
    }

    private static boolean containsLockToken(String[] tokens, String token) throws RepositoryException {
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals(token)) continue;
            return true;
        }
        return false;
    }

    public void testLockNonLockable() throws NotExecutableException, RepositoryException {
        if (this.testNode.isNodeType(this.mixLockable)) {
            throw new NotExecutableException();
        }
        try {
            this.lockMgr.lock(this.testPath, true, true, Long.MAX_VALUE, this.superuser.getUserID());
            LockManagerTest.fail((String)"Attempt to lock a non-lockable node must throw LockException.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testLockWithPendingChanges() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        this.testNode.addNode(this.nodeName2);
        try {
            this.lockMgr.lock(this.testPath, true, true, Long.MAX_VALUE, this.superuser.getUserID());
            LockManagerTest.fail((String)"Attempt to lock a node with transient modifications must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testNullOwnerHint() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        Lock l = this.lockMgr.lock(this.testPath, true, true, Long.MAX_VALUE, null);
        LockManagerTest.assertNotNull((Object)l.getLockOwner());
    }

    public void testGetLockTokens() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        LockManagerTest.assertTrue((String)"Creating open scoped lock must add token to the lock manager.", (boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
        LockManagerTest.assertTrue((String)"Creating open scoped lock must add token to the lock manager.", (boolean)LockManagerTest.containsLockToken(this.superuser.getLockTokens(), ltoken));
    }

    public void testGetLockTokensAfterUnlock() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        this.lockMgr.unlock(this.testPath);
        LockManagerTest.assertFalse((String)"Removing an open scoped lock must remove the token from the lock manager.", (boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
        LockManagerTest.assertFalse((String)"Removing an open scoped lock must remove the token from the lock manager.", (boolean)LockManagerTest.containsLockToken(this.superuser.getLockTokens(), ltoken));
    }

    public void testGetLockTokensSessionScoped() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        List<String> tokensBefore = Arrays.asList(this.lockMgr.getLockTokens());
        boolean sessionScoped = true;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        LockManagerTest.assertEquals((String)"Creating a session scoped lock must not change the lock tokens.", tokensBefore, Arrays.asList(this.lockMgr.getLockTokens()));
        LockManagerTest.assertEquals((String)"Creating a session scoped lock must not change the lock tokens.", tokensBefore, Arrays.asList(this.superuser.getLockTokens()));
    }

    public void testAddLockToken() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        this.lockMgr.addLockToken(ltoken);
    }

    public void testAddInvalidLockToken() throws RepositoryException {
        try {
            this.lockMgr.addLockToken("any-token");
            LockManagerTest.fail((String)"Adding an invalid token must fail.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddLockTokenToAnotherSession() throws RepositoryException, NotExecutableException {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        Session other = this.getHelper().getReadWriteSession();
        try {
            LockManager otherLockMgr = LockManagerTest.getLockManager(other);
            LockManagerTest.assertFalse((boolean)LockManagerTest.containsLockToken(otherLockMgr, ltoken));
            try {
                otherLockMgr.addLockToken(ltoken);
                LockManagerTest.fail((String)"Adding token to another session must fail.");
            }
            catch (LockException e) {
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            other.logout();
            throw throwable;
        }
        other.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLockToken() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        try {
            this.lockMgr.removeLockToken(ltoken);
            LockManagerTest.assertFalse((boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
            LockManagerTest.assertFalse((boolean)LockManagerTest.containsLockToken(this.superuser.getLockTokens(), ltoken));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lockMgr.addLockToken(ltoken);
            LockManagerTest.assertTrue((boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
            LockManagerTest.assertNotNull((String)"Token must be exposed again", (Object)l.getLockToken());
            LockManagerTest.assertEquals((String)"The lock must get the same token again.", (String)ltoken, (String)l.getLockToken());
            throw throwable;
        }
        this.lockMgr.addLockToken(ltoken);
        LockManagerTest.assertTrue((boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
        LockManagerTest.assertNotNull((String)"Token must be exposed again", (Object)l.getLockToken());
        LockManagerTest.assertEquals((String)"The lock must get the same token again.", (String)ltoken, (String)l.getLockToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLockToken2() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        try {
            this.lockMgr.removeLockToken(ltoken);
            LockManagerTest.assertNull((String)"Lock token must not be exposed any more.", (Object)l.getLockToken());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lockMgr.addLockToken(ltoken);
            throw throwable;
        }
        this.lockMgr.addLockToken(ltoken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLockToken3() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        try {
            this.lockMgr.removeLockToken(ltoken);
            try {
                this.testNode.addNode(this.nodeName2, this.testNodeType);
                LockManagerTest.fail((String)"Session must not be allowed to modify node");
            }
            catch (LockException e) {
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lockMgr.addLockToken(ltoken);
            throw throwable;
        }
        this.lockMgr.addLockToken(ltoken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveLockTokenTwice() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        this.lockMgr.removeLockToken(ltoken);
        try {
            try {
                this.lockMgr.removeLockToken(ltoken);
                LockManagerTest.fail((String)"Removing a lock token twice must fail.");
            }
            catch (LockException e) {
                Object var6_5 = null;
                this.lockMgr.addLockToken(ltoken);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lockMgr.addLockToken(ltoken);
            throw throwable;
        }
        this.lockMgr.addLockToken(ltoken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddLockTokenAgain() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        try {
            this.lockMgr.removeLockToken(ltoken);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lockMgr.addLockToken(ltoken);
            LockManagerTest.assertTrue((boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
            LockManagerTest.assertNotNull((String)"Token must be exposed again", (Object)l.getLockToken());
            LockManagerTest.assertEquals((String)"The lock must get the same token again.", (String)ltoken, (String)l.getLockToken());
            throw throwable;
        }
        this.lockMgr.addLockToken(ltoken);
        LockManagerTest.assertTrue((boolean)LockManagerTest.containsLockToken(this.lockMgr, ltoken));
        LockManagerTest.assertNotNull((String)"Token must be exposed again", (Object)l.getLockToken());
        LockManagerTest.assertEquals((String)"The lock must get the same token again.", (String)ltoken, (String)l.getLockToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockTransfer() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        Session other = this.getHelper().getReadWriteSession();
        LockManager otherLockMgr = LockManagerTest.getLockManager(other);
        try {
            this.lockMgr.removeLockToken(ltoken);
            otherLockMgr.addLockToken(ltoken);
            LockManagerTest.assertTrue((String)"The new holding manager must contain the token.", (boolean)LockManagerTest.containsLockToken(otherLockMgr, ltoken));
            Lock otherL = otherLockMgr.getLock(this.testPath);
            LockManagerTest.assertNotNull((String)"Token must be exposed to new lock holder.", (Object)otherL.getLockToken());
            LockManagerTest.assertEquals((String)"Token must be the same again.", (String)ltoken, (String)otherL.getLockToken());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            otherLockMgr.removeLockToken(ltoken);
            this.lockMgr.addLockToken(ltoken);
            other.logout();
            throw throwable;
        }
        otherLockMgr.removeLockToken(ltoken);
        this.lockMgr.addLockToken(ltoken);
        other.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testLockTransfer2() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        Session other = this.getHelper().getReadWriteSession();
        LockManager otherLockMgr = LockManagerTest.getLockManager(other);
        try {
            try {
                this.lockMgr.removeLockToken(ltoken);
                otherLockMgr.addLockToken(ltoken);
                this.lockMgr.addLockToken(ltoken);
                LockManagerTest.fail((String)"Adding the token to another session must fail.");
            }
            catch (LockException e) {
                Object var8_7 = null;
                otherLockMgr.removeLockToken(ltoken);
                this.lockMgr.addLockToken(ltoken);
                other.logout();
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            otherLockMgr.removeLockToken(ltoken);
            this.lockMgr.addLockToken(ltoken);
            other.logout();
            throw throwable;
        }
        otherLockMgr.removeLockToken(ltoken);
        this.lockMgr.addLockToken(ltoken);
        other.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testLockTransfer3() throws Exception {
        this.assertLockable(this.testNode);
        boolean sessionScoped = false;
        Lock l = this.lockMgr.lock(this.testPath, true, sessionScoped, Long.MAX_VALUE, null);
        String ltoken = l.getLockToken();
        Session other = this.getHelper().getReadWriteSession();
        LockManager otherLockMgr = LockManagerTest.getLockManager(other);
        try {
            try {
                this.lockMgr.removeLockToken(ltoken);
                otherLockMgr.addLockToken(ltoken);
                this.lockMgr.removeLockToken(ltoken);
                LockManagerTest.fail((String)"Removing a token that has been transfered to another manager must fail.");
            }
            catch (LockException e) {
                Object var8_7 = null;
                otherLockMgr.removeLockToken(ltoken);
                this.lockMgr.addLockToken(ltoken);
                other.logout();
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            otherLockMgr.removeLockToken(ltoken);
            this.lockMgr.addLockToken(ltoken);
            other.logout();
            throw throwable;
        }
        otherLockMgr.removeLockToken(ltoken);
        this.lockMgr.addLockToken(ltoken);
        other.logout();
    }
}

