/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyStringTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 1, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No string property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value stringValue = NodeTypeUtil.getValueOfType(this.superuser, 1);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a StringValue", (boolean)nodeType.canSetProperty(propDef.getName(), stringValue));
        Value binaryValue = NodeTypeUtil.getValueOfType(this.superuser, 2);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a BinaryValue and is UTF-8", (boolean)nodeType.canSetProperty(propDef.getName(), binaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValue));
        Value pathValue = NodeTypeUtil.getValueOfType(this.superuser, 8);
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type String and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 1, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple string property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value stringValue = NodeTypeUtil.getValueOfType(this.superuser, 1);
        Value[] stringValues = new Value[]{stringValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type StringValue", (boolean)nodeType.canSetProperty(propDef.getName(), stringValues));
        Value binaryValue = NodeTypeUtil.getValueOfType(this.superuser, 2);
        Value[] binaryValues = new Value[]{binaryValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type BinaryValue and is UTF-8", (boolean)nodeType.canSetProperty(propDef.getName(), binaryValues));
        Value dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        Value[] dateValues = new Value[]{dateValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        Value[] doubleValues = new Value[]{doubleValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        Value[] longValues = new Value[]{longValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        Value[] booleanValues = new Value[]{booleanValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        Value[] nameValues = new Value[]{nameValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value pathValue = NodeTypeUtil.getValueOfType(this.superuser, 8);
        Value[] pathValues = new Value[]{pathValue};
        CanSetPropertyStringTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type String and values are of type PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 1, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No string property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No string property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyStringTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 1, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple string property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple string property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyStringTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

