/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class TextNodeTest
extends AbstractQueryTest {
    private String jcrXMLText;
    private String jcrXMLCharacters;

    protected void setUp() throws Exception {
        super.setUp();
        this.jcrXMLText = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":xmltext";
        this.jcrXMLCharacters = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":xmlcharacters";
    }

    public void testTextNodeTest() throws RepositoryException, NotExecutableException {
        Node text1 = this.testRootNode.addNode(this.jcrXMLText);
        text1.setProperty(this.jcrXMLCharacters, "foo");
        this.testRootNode.save();
        String xpath = "/" + this.jcrRoot + this.testRoot + "/text()";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text1});
    }

    public void testTextNodeTestMultiNodes() throws RepositoryException, NotExecutableException {
        Node text1 = this.testRootNode.addNode(this.jcrXMLText);
        text1.setProperty(this.jcrXMLCharacters, "foo");
        Node text2 = this.testRootNode.addNode(this.nodeName1, this.testNodeType).addNode(this.jcrXMLText);
        text2.setProperty(this.jcrXMLCharacters, "foo");
        this.testRootNode.save();
        String xpath = "/" + this.jcrRoot + this.testRoot + "//text()";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text1, text2});
    }

    public void testTextNodeTestContains() throws RepositoryException, NotExecutableException {
        Node text1 = this.testRootNode.addNode(this.jcrXMLText);
        text1.setProperty(this.jcrXMLCharacters, "the quick brown fox jumps over the lazy dog.");
        Node text2 = this.testRootNode.addNode(this.nodeName1, this.testNodeType).addNode(this.jcrXMLText);
        text2.setProperty(this.jcrXMLCharacters, "java content repository");
        this.testRootNode.save();
        String xpath = "/" + this.jcrRoot + this.testRoot + "//text()[" + this.jcrContains + "(., 'fox')]";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text1});
    }

    public void testTextNodeTestWithPosition() throws RepositoryException, NotExecutableException {
        if (!this.isSupported("query.xpath.pos.index")) {
            throw new NotExecutableException("Repository does not support position index");
        }
        Node text1 = this.testRootNode.addNode(this.jcrXMLText);
        text1.setProperty(this.jcrXMLCharacters, "foo");
        if (!text1.getDefinition().allowsSameNameSiblings()) {
            throw new NotExecutableException("Node at path: " + this.testRoot + " does not allow same name siblings with name: " + this.jcrXMLText);
        }
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node text2 = this.testRootNode.addNode(this.jcrXMLText);
        text2.setProperty(this.jcrXMLCharacters, "foo");
        this.testRootNode.save();
        String xpath = "/" + this.jcrRoot + this.testRoot + "/text()[2]";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text2});
        xpath = "/" + this.jcrRoot + this.testRoot + "/text()[last()]";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text2});
        xpath = "/" + this.jcrRoot + this.testRoot + "/text()[position() = 2]";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text2});
        xpath = "/" + this.jcrRoot + this.testRoot + "/text()[first()]";
        this.executeXPathQuery(this.superuser, xpath, new Node[]{text1});
    }
}

