/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceSameNameSibsTest;

public class WorkspaceMoveSameNameSibsTest
extends AbstractWorkspaceSameNameSibsTest {
    @Override
    protected String getOtherWorkspaceName() throws NotExecutableException {
        return this.workspace.getName();
    }

    @Override
    protected void initNodesW2() throws RepositoryException {
    }

    public void testMoveNodesOrderingSupportedByParent() throws RepositoryException {
        String[] orderList = new String[]{this.nodeName1, this.nodeName2, this.nodeName3};
        Node newNode = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.getSession().save();
        for (int i = 0; i < orderList.length; ++i) {
            this.workspace.copy(this.node1.getPath(), newNode.getPath() + "/" + orderList[i]);
        }
        int cnt = 0;
        NodeIterator iter = this.node2.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            WorkspaceMoveSameNameSibsTest.assertTrue((boolean)n.getName().equals(orderList[cnt]));
            ++cnt;
        }
    }

    public void testMoveNodesNodeExistsAtDestPath() throws RepositoryException {
        Node snsfNode = this.testRootNode.addNode(this.nodeName3, this.sameNameSibsFalseNodeType.getName());
        this.testRootNode.getSession().save();
        String dstAbsPath = snsfNode.getPath() + "/" + this.node1.getName();
        this.workspace.copy(this.node1.getPath(), dstAbsPath);
        try {
            this.workspace.move(this.node1.getPath(), dstAbsPath);
            WorkspaceMoveSameNameSibsTest.fail((String)("Node exists below '" + dstAbsPath + "'. Test should fail."));
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }
}

