/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyBinaryTest
extends AbstractJCRTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 2, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No string property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value stringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a StringValue", (boolean)nodeType.canSetProperty(propDef.getName(), stringValue));
        Value binaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a BinaryValue", (boolean)nodeType.canSetProperty(propDef.getName(), binaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValue));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Binary and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 2, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple string property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value binaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        Value stringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        Value[] stringValues = new Value[]{stringValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type StringValue", (boolean)nodeType.canSetProperty(propDef.getName(), stringValues));
        Value[] binaryValues = new Value[]{binaryValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type BinaryValue", (boolean)nodeType.canSetProperty(propDef.getName(), binaryValues));
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        Value[] dateValues = new Value[]{dateValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        Value[] doubleValues = new Value[]{doubleValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        Value[] longValues = new Value[]{longValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        Value[] booleanValues = new Value[]{booleanValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        Value[] nameValues = new Value[]{nameValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        Value[] pathValues = new Value[]{pathValue};
        CanSetPropertyBinaryTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Binary and values are of type PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 2, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No binary property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.session, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No binary property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyBinaryTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 2, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple binary property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.session, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple binary property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyBinaryTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

