/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;

public class GetInfoTest
extends AbstractObservationTest {
    public void testNodeAdded() throws RepositoryException {
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetInfoTest.this.testRootNode.addNode(GetInfoTest.this.nodeName1, GetInfoTest.this.testNodeType);
                GetInfoTest.this.testRootNode.getSession().save();
            }
        }, 1);
        for (int i = 0; i < events.length; ++i) {
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)events[i].getInfo().size());
        }
    }

    public void testNodeRemoved() throws RepositoryException {
        final Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                n.remove();
                GetInfoTest.this.testRootNode.getSession().save();
            }
        }, 2);
        for (int i = 0; i < events.length; ++i) {
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)events[i].getInfo().size());
        }
    }

    public void testPropertyAdded() throws RepositoryException {
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetInfoTest.this.testRootNode.addNode(GetInfoTest.this.nodeName1, GetInfoTest.this.testNodeType).setProperty(GetInfoTest.this.propertyName1, "test");
                GetInfoTest.this.testRootNode.getSession().save();
            }
        }, 4);
        for (int i = 0; i < events.length; ++i) {
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)events[i].getInfo().size());
        }
    }

    public void testPropertyChanged() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        final Property prop = n.setProperty(this.propertyName1, "test");
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                prop.setValue("modified");
            }
        }, 16);
        for (int i = 0; i < events.length; ++i) {
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)events[i].getInfo().size());
        }
    }

    public void testPropertyRemoved() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        final Property prop = n.setProperty(this.propertyName1, "test");
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                prop.remove();
            }
        }, 8);
        for (int i = 0; i < events.length; ++i) {
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)events[i].getInfo().size());
        }
    }
}

