/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryStubException;

public abstract class RepositoryStub {
    public static final String STUB_IMPL_PROPS = "repositoryStubImpl.properties";
    public static final String PROP_PREFIX = "javax.jcr.tck";
    public static final String STUB_IMPL_SYS_PROPS = "javax.jcr.tck.properties";
    public static final String PROP_STUB_IMPL_CLASS = "javax.jcr.tck.repository_stub_impl";
    public static final String PROP_SUPERUSER_PWD = "superuser.pwd";
    public static final String PROP_SUPERUSER_NAME = "superuser.name";
    public static final String PROP_READONLY_PWD = "readonly.pwd";
    public static final String PROP_READONLY_NAME = "readonly.name";
    public static final String PROP_READWRITE_PWD = "readwrite.pwd";
    public static final String PROP_READWRITE_NAME = "readwrite.name";
    public static final String PROP_NODETYPE = "nodetype";
    public static final String PROP_NODETYPETESTROOT = "nodetypetestroot";
    public static final String PROP_NODETYPENOCHILDREN = "nodetypenochildren";
    public static final String PROP_TESTROOT = "testroot";
    public static final String PROP_NODE_NAME1 = "nodename1";
    public static final String PROP_NODE_NAME2 = "nodename2";
    public static final String PROP_NODE_NAME3 = "nodename3";
    public static final String PROP_NODE_NAME4 = "nodename4";
    public static final String PROP_PROP_NAME1 = "propertyname1";
    public static final String PROP_PROP_NAME2 = "propertyname2";
    public static final String PROP_PROP_VALUE1 = "propertyvalue1";
    public static final String PROP_PROP_VALUE2 = "propertyvalue2";
    public static final String PROP_PROP_TYPE1 = "propertytype1";
    public static final String PROP_PROP_TYPE2 = "propertytype2";
    public static final String PROP_WORKSPACE_NAME = "workspacename";
    public static final String PROP_NAMESPACES = "namespaces";
    public static final String PROP_LOCK_TIMEOUT = "lock.timeout";
    public static final String PROP_LOCK_OWNER = "lock.owner";
    public static final String PROP_HOLD_NAME = "holdname";
    public static final String RETENTION_POLICY_HOLDER = "retentionpolicyholder";
    public static final String REPOSITORY_FACTORY = "repository.factory";
    protected final Properties environment;
    protected SimpleCredentials superuser;
    protected SimpleCredentials readonly;
    protected SimpleCredentials readwrite;

    protected RepositoryStub(Properties env) {
        if (env == null) {
            throw new IllegalArgumentException("Parameter 'env' must not be null!");
        }
        this.environment = env;
        this.superuser = new SimpleCredentials(env.getProperty("javax.jcr.tck.superuser.name", ""), env.getProperty("javax.jcr.tck.superuser.pwd", "").toCharArray());
        this.readonly = new SimpleCredentials(env.getProperty("javax.jcr.tck.readonly.name", ""), env.getProperty("javax.jcr.tck.readonly.pwd", "").toCharArray());
        this.readwrite = new SimpleCredentials(env.getProperty("javax.jcr.tck.readwrite.name", ""), env.getProperty("javax.jcr.tck.readwrite.pwd", "").toCharArray());
    }

    public static synchronized RepositoryStub getInstance(Map configuration) throws RepositoryStubException {
        Properties props = null;
        RepositoryStub stub = null;
        String implProp = System.getProperty(STUB_IMPL_SYS_PROPS);
        if (implProp != null) {
            File implPropFile = new File(implProp);
            if (implPropFile.exists()) {
                props = new Properties();
                try {
                    props.load(new FileInputStream(implPropFile));
                }
                catch (IOException e) {
                    throw new RepositoryStubException("Unable to load config file: " + implProp, e);
                }
            } else {
                throw new RepositoryStubException("File does not exist: " + implProp);
            }
        }
        if (props == null) {
            props = new Properties();
            InputStream is = RepositoryStub.class.getClassLoader().getResourceAsStream(STUB_IMPL_PROPS);
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    throw new RepositoryStubException("Exception reading repositoryStubImpl.properties", e);
                }
            }
        }
        props.putAll((Map<?, ?>)configuration);
        try {
            String className = props.getProperty(PROP_STUB_IMPL_CLASS);
            if (className == null || className.length() == 0) {
                throw new RepositoryStubException("Property javax.jcr.tck.repository_stub_impl not defined!");
            }
            Class<?> stubClass = Class.forName(className);
            Constructor<?> constr = stubClass.getConstructor(Properties.class);
            stub = (RepositoryStub)constr.newInstance(props);
        }
        catch (Exception e) {
            throw new RepositoryStubException(e);
        }
        return stub;
    }

    public abstract Repository getRepository() throws RepositoryStubException;

    public Credentials getSuperuserCredentials() {
        return this.superuser;
    }

    public Credentials getReadWriteCredentials() {
        return this.readwrite;
    }

    public Credentials getReadOnlyCredentials() {
        return this.readonly;
    }

    public String getProperty(String name) {
        return this.environment.getProperty(name);
    }

    public abstract Principal getKnownPrincipal(Session var1) throws RepositoryException;

    public abstract Principal getUnknownPrincipal(Session var1) throws RepositoryException, NotExecutableException;
}

