/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyMultipleTest
extends AbstractJCRTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testReturnFalseBecauseIsProtected() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, -1, true, true, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No protected, multiple property def found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value value = NodeTypeUtil.getValueOfType(this.superuser, propDef.getRequiredType());
        Value[] values = new Value[]{value, value};
        CanSetPropertyMultipleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is protected.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }

    public void testReturnFalseBecauseIsNotMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, -1, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No not multiple, not protected property def found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value value = NodeTypeUtil.getValueOfType(this.superuser, propDef.getRequiredType());
        Value[] values = new Value[]{value};
        CanSetPropertyMultipleTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is not multiple", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }

    public void testMultipleValuesNull() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, -1, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No not protected, multiple property def found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyMultipleTest.assertEquals((String)"nodeType.canSetProperty(String propertyName, Value[] values) where values is null must return the same result as nodeType.canRemoveItem(String propertyName)", (boolean)nodeType.canRemoveItem(propDef.getName()), (boolean)nodeType.canSetProperty(propDef.getName(), (Value[])null));
    }
}

