/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class ColumnTest
extends AbstractQOMTest {
    private static final String SELECTOR_1 = "s";
    private static final String SELECTOR_2 = "p";
    private static final String TEST_VALUE = "value";

    public void testExpandColumnsForNodeType() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, SELECTOR_1), null, null, new Column[]{this.qf.column(SELECTOR_1, null, null)});
        this.forQOMandSQL2(qom, new AbstractQOMTest.Callable(){

            @Override
            public Object call(Query query) throws RepositoryException {
                QueryResult result = query.execute();
                NodeTypeManager ntMgr = ColumnTest.this.superuser.getWorkspace().getNodeTypeManager();
                NodeType nt = ntMgr.getNodeType(ColumnTest.this.testNodeType);
                PropertyDefinition[] propDefs = nt.getPropertyDefinitions();
                HashSet<String> names = new HashSet<String>();
                for (int i = 0; i < propDefs.length; ++i) {
                    PropertyDefinition propDef = propDefs[i];
                    if (propDef.isMultiple() || propDef.getName().equals("*")) continue;
                    String columnName = "s." + propDef.getName();
                    names.add(columnName);
                }
                for (String columnName : result.getColumnNames()) {
                    names.remove(columnName);
                }
                Assert.assertTrue((String)("Missing required column(s): " + names), (boolean)names.isEmpty());
                return null;
            }
        });
    }

    public void testColumnNames() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, SELECTOR_1), null, null, new Column[]{this.qf.column(SELECTOR_1, this.propertyName1, this.propertyName1)});
        this.forQOMandSQL2(qom, new AbstractQOMTest.Callable(){

            @Override
            public Object call(Query query) throws RepositoryException {
                QueryResult result = query.execute();
                ArrayList<String> names = new ArrayList<String>(Arrays.asList(result.getColumnNames()));
                Assert.assertTrue((String)("Missing column: " + ColumnTest.this.propertyName1), (boolean)names.remove(ColumnTest.this.propertyName1));
                Iterator it = names.iterator();
                while (it.hasNext()) {
                    Assert.fail((String)((String)it.next() + " was not declared as a column"));
                }
                return null;
            }
        });
    }

    public void testMultiColumn() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.setProperty(this.propertyName1, TEST_VALUE);
        this.superuser.save();
        final String columnName1 = "s." + this.propertyName1;
        final String columnName2 = "p." + this.propertyName1;
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.join((Source)this.qf.selector(this.testNodeType, SELECTOR_1), (Source)this.qf.selector(this.testNodeType, SELECTOR_2), "jcr.join.type.inner", (JoinCondition)this.qf.equiJoinCondition(SELECTOR_1, this.propertyName1, SELECTOR_2, this.propertyName1)), (Constraint)this.qf.descendantNode(SELECTOR_1, this.testRoot), null, new Column[]{this.qf.column(SELECTOR_1, this.propertyName1, columnName1), this.qf.column(SELECTOR_2, this.propertyName1, columnName2)});
        this.forQOMandSQL2(qom, new AbstractQOMTest.Callable(){

            @Override
            public Object call(Query query) throws RepositoryException {
                RowIterator rows = query.execute().getRows();
                Assert.assertTrue((String)"empty result", (boolean)rows.hasNext());
                Row r = rows.nextRow();
                Assert.assertEquals((String)"unexpected value", (String)ColumnTest.TEST_VALUE, (String)r.getValue(columnName1).getString());
                Assert.assertEquals((String)"unexpected value", (String)ColumnTest.TEST_VALUE, (String)r.getValue(columnName2).getString());
                return null;
            }
        });
    }
}

