/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NodeEntry
extends HierarchyEntry {
    public NodeId getId() throws InvalidItemStateException, RepositoryException;

    public NodeId getWorkspaceId() throws InvalidItemStateException, RepositoryException;

    public String getUniqueID();

    public void setUniqueID(String var1);

    public int getIndex() throws InvalidItemStateException, RepositoryException;

    public NodeState getNodeState() throws ItemNotFoundException, RepositoryException;

    public NodeEntry getDeepNodeEntry(Path var1) throws PathNotFoundException, RepositoryException;

    public PropertyEntry getDeepPropertyEntry(Path var1) throws PathNotFoundException, RepositoryException;

    public HierarchyEntry lookupDeepEntry(Path var1);

    public boolean hasNodeEntry(Name var1);

    public boolean hasNodeEntry(Name var1, int var2);

    public NodeEntry getNodeEntry(Name var1, int var2) throws RepositoryException;

    public NodeEntry getNodeEntry(Name var1, int var2, boolean var3) throws RepositoryException;

    public Iterator<NodeEntry> getNodeEntries() throws RepositoryException;

    public List<NodeEntry> getNodeEntries(Name var1) throws RepositoryException;

    public void setNodeEntries(Iterator<ChildInfo> var1) throws RepositoryException;

    public NodeEntry getOrAddNodeEntry(Name var1, int var2, String var3) throws RepositoryException;

    public NodeEntry addNewNodeEntry(Name var1, String var2, Name var3, QNodeDefinition var4) throws RepositoryException;

    public boolean hasPropertyEntry(Name var1);

    public PropertyEntry getPropertyEntry(Name var1) throws RepositoryException;

    public PropertyEntry getPropertyEntry(Name var1, boolean var2) throws RepositoryException;

    public Iterator<PropertyEntry> getPropertyEntries();

    public PropertyEntry getOrAddPropertyEntry(Name var1) throws ItemExistsException, RepositoryException;

    public void setPropertyEntries(Collection<Name> var1) throws ItemExistsException, RepositoryException;

    public PropertyEntry addNewPropertyEntry(Name var1, QPropertyDefinition var2, QValue[] var3, int var4) throws ItemExistsException, RepositoryException;

    public void orderBefore(NodeEntry var1) throws RepositoryException;

    public NodeEntry move(Name var1, NodeEntry var2, boolean var3) throws RepositoryException;

    public boolean isTransientlyMoved();

    public void refresh(Event var1);
}

