/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperation
implements Operation {
    private final Collection<ItemState> affectedStates = new ArrayList<ItemState>();
    protected int status;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Collection<ItemState> getAffectedItemStates() {
        if (this.affectedStates.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.affectedStates);
    }

    @Override
    public void undo() throws RepositoryException {
        assert (this.status == 0);
        throw new UnsupportedOperationException("Undo not supported.");
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected void addAffectedItemState(ItemState affectedState) {
        this.affectedStates.add(affectedState);
    }

    protected static NodeState getNodeState(Path nodePath, HierarchyManager hierMgr) throws PathNotFoundException, RepositoryException {
        NodeState nodeState = hierMgr.getNodeState(nodePath);
        return nodeState;
    }

    protected static void assertChildNodeEntries(NodeState parentState) throws RepositoryException {
        parentState.getNodeEntry().getNodeEntries();
    }
}

