/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.NodeId;

public class ResolveMergeConflict
extends AbstractOperation {
    private final NodeState nodeState;
    private final NodeId[] mergeFailedIds;
    private final NodeId[] predecessorIds;
    private final boolean resolveDone;

    private ResolveMergeConflict(NodeState nodeState, NodeId[] mergeFailedIds, NodeId[] predecessorIds, boolean resolveDone) {
        this.nodeState = nodeState;
        this.mergeFailedIds = mergeFailedIds;
        this.predecessorIds = predecessorIds;
        this.resolveDone = resolveDone;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        Iterator<PropertyEntry> propEntries = ((NodeEntry)this.nodeState.getHierarchyEntry()).getPropertyEntries();
        while (propEntries.hasNext()) {
            PropertyEntry pe = propEntries.next();
            pe.invalidate(false);
        }
        this.nodeState.getHierarchyEntry().invalidate(false);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public NodeId[] getMergeFailedIds() {
        return this.mergeFailedIds;
    }

    public NodeId[] getPredecessorIds() {
        return this.predecessorIds;
    }

    public boolean resolveDone() {
        return this.resolveDone;
    }

    public static Operation create(NodeState nodeState, NodeId[] mergeFailedIds, NodeId[] predecessorIds, boolean resolveDone) {
        ResolveMergeConflict up = new ResolveMergeConflict(nodeState, mergeFailedIds, predecessorIds, resolveDone);
        return up;
    }
}

