/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.ArrayList;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPrimaryType;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLog {
    private static final Logger log = LoggerFactory.getLogger(ChangeLog.class);
    private final ItemState target;
    private final Set<Operation> operations;
    private final Set<ItemState> affectedStates;

    ChangeLog(ItemState target, Set<Operation> operations, Set<ItemState> affectedStates) throws InvalidItemStateException, ConstraintViolationException {
        this.target = target;
        this.operations = operations;
        this.affectedStates = affectedStates;
    }

    public void persisted() throws RepositoryException {
        ArrayList<NodeState> changedMixins = new ArrayList<NodeState>();
        ArrayList<NodeState> changedPrimaryTypes = new ArrayList<NodeState>();
        Operation[] ops = this.operations.toArray(new Operation[this.operations.size()]);
        for (int i = 0; i < ops.length; ++i) {
            ops[i].persisted();
            if (ops[i] instanceof SetMixin) {
                changedMixins.add(((SetMixin)ops[i]).getNodeState());
                continue;
            }
            if (!(ops[i] instanceof SetPrimaryType)) continue;
            changedPrimaryTypes.add(((SetPrimaryType)ops[i]).getNodeState());
        }
        for (ItemState state : this.affectedStates) {
            HierarchyEntry he = state.getHierarchyEntry();
            switch (state.getStatus()) {
                case 2: {
                    state.setStatus(1);
                    if (!state.isNode()) break;
                    if (changedPrimaryTypes.contains(state)) {
                        he.invalidate(true);
                        break;
                    }
                    if (!changedMixins.contains(state)) break;
                    he.invalidate(false);
                    break;
                }
                case 3: {
                    he.remove();
                    break;
                }
                case 4: {
                    log.error("ChangeLog still contains NEW state: " + state.getName());
                    state.setStatus(1);
                    break;
                }
                case -1: 
                case 5: 
                case 6: 
                case 7: {
                    log.error("ChangeLog contains state (" + state.getName() + ") with illegal status " + Status.getName(state.getStatus()));
                    break;
                }
                case 1: {
                    if (!state.isNode() || !changedMixins.contains(state)) break;
                    he.invalidate(false);
                    break;
                }
                case 0: 
                case 8: {
                    he.invalidate(false);
                }
            }
        }
    }

    public void undo() throws RepositoryException {
        Operation[] ops = this.operations.toArray(new Operation[this.operations.size()]);
        for (int i = ops.length - 1; i >= 0; --i) {
            ops[i].undo();
        }
        for (ItemState state : this.affectedStates) {
            switch (state.getStatus()) {
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    state.getHierarchyEntry().revert();
                    break;
                }
                case 4: {
                    log.error("ChangeLog still contains NEW state: " + state.getName());
                    state.getHierarchyEntry().revert();
                    break;
                }
                case -1: 
                case 7: {
                    log.error("ChangeLog contains state (" + state.getName() + ") with illegal status " + Status.getName(state.getStatus()));
                    break;
                }
            }
        }
    }

    public ItemState getTarget() {
        return this.target;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public Set<ItemState> getAffectedStates() {
        return this.affectedStates;
    }

    void reset() {
        this.affectedStates.clear();
        this.operations.clear();
    }
}

