/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AddLabel;
import org.apache.jackrabbit.jcr2spi.operation.Checkin;
import org.apache.jackrabbit.jcr2spi.operation.Checkout;
import org.apache.jackrabbit.jcr2spi.operation.Checkpoint;
import org.apache.jackrabbit.jcr2spi.operation.CreateActivity;
import org.apache.jackrabbit.jcr2spi.operation.CreateConfiguration;
import org.apache.jackrabbit.jcr2spi.operation.Merge;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.RemoveActivity;
import org.apache.jackrabbit.jcr2spi.operation.RemoveLabel;
import org.apache.jackrabbit.jcr2spi.operation.RemoveVersion;
import org.apache.jackrabbit.jcr2spi.operation.ResolveMergeConflict;
import org.apache.jackrabbit.jcr2spi.operation.Restore;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionManagerImpl
implements VersionManager {
    private final WorkspaceManager workspaceManager;

    public VersionManagerImpl(WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    @Override
    public NodeEntry checkin(NodeState nodeState) throws RepositoryException {
        Checkin ci = Checkin.create(nodeState, this);
        this.workspaceManager.execute(ci);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(ci.getNewVersionId());
    }

    @Override
    public void checkout(NodeState nodeState) throws RepositoryException {
        Operation co = Checkout.create(nodeState, this);
        this.workspaceManager.execute(co);
    }

    @Override
    public void checkout(NodeState nodeState, NodeId activityId) throws RepositoryException {
        Operation co = Checkout.create(nodeState, activityId, this);
        this.workspaceManager.execute(co);
    }

    @Override
    public NodeEntry checkpoint(NodeState nodeState) throws RepositoryException {
        Checkpoint cp = Checkpoint.create(nodeState, this);
        this.workspaceManager.execute(cp);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(cp.getNewVersionId());
    }

    @Override
    public NodeEntry checkpoint(NodeState nodeState, NodeId activityId) throws RepositoryException {
        Checkpoint cp = Checkpoint.create(nodeState, activityId, this);
        this.workspaceManager.execute(cp);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(cp.getNewVersionId());
    }

    @Override
    public boolean isCheckedOut(NodeState nodeState) throws RepositoryException {
        if (nodeState.getStatus() == 4) {
            return true;
        }
        NodeEntry nodeEntry = nodeState.getNodeEntry();
        try {
            while (!nodeEntry.hasPropertyEntry(NameConstants.JCR_ISCHECKEDOUT)) {
                NodeEntry parent = nodeEntry.getParent();
                if (parent == null) {
                    return true;
                }
                nodeEntry = parent;
            }
            PropertyState propState = nodeEntry.getPropertyEntry(NameConstants.JCR_ISCHECKEDOUT).getPropertyState();
            Boolean b = Boolean.valueOf(propState.getValue().getString());
            return b;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return true;
        }
    }

    @Override
    public void checkIsCheckedOut(NodeState nodeState) throws VersionException, RepositoryException {
        if (!this.isCheckedOut(nodeState)) {
            throw new VersionException(nodeState + " is checked-in");
        }
    }

    @Override
    public void removeVersion(NodeState versionHistoryState, NodeState versionState) throws RepositoryException {
        Operation op = RemoveVersion.create(versionState, versionHistoryState, this);
        this.workspaceManager.execute(op);
    }

    @Override
    public void addVersionLabel(NodeState versionHistoryState, NodeState versionState, Name qLabel, boolean moveLabel) throws RepositoryException {
        Operation op = AddLabel.create(versionHistoryState, versionState, qLabel, moveLabel);
        this.workspaceManager.execute(op);
    }

    @Override
    public void removeVersionLabel(NodeState versionHistoryState, NodeState versionState, Name qLabel) throws RepositoryException {
        Operation op = RemoveLabel.create(versionHistoryState, versionState, qLabel);
        this.workspaceManager.execute(op);
    }

    @Override
    public void restore(NodeState nodeState, Path relativePath, NodeState versionState, boolean removeExisting) throws RepositoryException {
        Operation op = Restore.create(nodeState, relativePath, versionState, removeExisting);
        this.workspaceManager.execute(op);
    }

    @Override
    public void restore(NodeState[] versionStates, boolean removeExisting) throws RepositoryException {
        Operation op = Restore.create(versionStates, removeExisting);
        this.workspaceManager.execute(op);
    }

    @Override
    public Iterator<NodeId> merge(NodeState nodeState, String workspaceName, boolean bestEffort) throws RepositoryException {
        return this.merge(nodeState, workspaceName, bestEffort, false);
    }

    @Override
    public Iterator<NodeId> merge(NodeState nodeState, String workspaceName, boolean bestEffort, boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        Merge op = Merge.create(nodeState, workspaceName, bestEffort, isShallow, this);
        this.workspaceManager.execute(op);
        return op.getFailedIds();
    }

    @Override
    public void resolveMergeConflict(NodeState nodeState, NodeState versionState, boolean done) throws RepositoryException {
        NodeId vId = versionState.getNodeId();
        PropertyState mergeFailedState = nodeState.getPropertyState(NameConstants.JCR_MERGEFAILED);
        QValue[] vs = mergeFailedState.getValues();
        NodeId[] mergeFailedIds = new NodeId[vs.length - 1];
        int j = 0;
        for (int i = 0; i < vs.length; ++i) {
            NodeId id = this.workspaceManager.getIdFactory().createNodeId(vs[i].getString());
            if (id.equals(vId)) continue;
            mergeFailedIds[j] = id;
            ++j;
        }
        PropertyState predecessorState = nodeState.getPropertyState(NameConstants.JCR_PREDECESSORS);
        vs = predecessorState.getValues();
        int noOfPredecessors = done ? vs.length + 1 : vs.length;
        NodeId[] predecessorIds = new NodeId[noOfPredecessors];
        for (int i = 0; i < vs.length; ++i) {
            predecessorIds[i] = this.workspaceManager.getIdFactory().createNodeId(vs[i].getString());
        }
        if (done) {
            predecessorIds[i] = vId;
        }
        Operation op = ResolveMergeConflict.create(nodeState, mergeFailedIds, predecessorIds, done);
        this.workspaceManager.execute(op);
    }

    @Override
    public NodeEntry createConfiguration(NodeState nodeState) throws UnsupportedRepositoryOperationException, RepositoryException {
        CreateConfiguration op = CreateConfiguration.create(nodeState, this);
        this.workspaceManager.execute(op);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(op.getNewConfigurationId());
    }

    @Override
    public NodeEntry createActivity(String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        CreateActivity op = CreateActivity.create(title, this);
        this.workspaceManager.execute(op);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(op.getNewActivityId());
    }

    @Override
    public void removeActivity(NodeState activityState) throws UnsupportedRepositoryOperationException, RepositoryException {
        Operation op = RemoveActivity.create(activityState, this.workspaceManager.getHierarchyManager());
        this.workspaceManager.execute(op);
    }

    @Override
    public Iterator<NodeId> mergeActivity(NodeState activityState) throws UnsupportedRepositoryOperationException, RepositoryException {
        Merge op = Merge.create(activityState, null, false, false, this);
        this.workspaceManager.execute(op);
        return op.getFailedIds();
    }

    @Override
    public NodeEntry getVersionableNodeEntry(NodeState versionState) throws RepositoryException {
        NodeState ns = versionState.getChildNodeState(NameConstants.JCR_FROZENNODE, 1);
        PropertyState ps = ns.getPropertyState(NameConstants.JCR_FROZENUUID);
        String uniqueID = ps.getValue().getString();
        NodeId versionableId = this.workspaceManager.getIdFactory().createNodeId(uniqueID);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(versionableId);
    }

    @Override
    public NodeEntry getVersionHistoryEntry(NodeState versionableState) throws RepositoryException {
        PropertyState ps = versionableState.getPropertyState(NameConstants.JCR_VERSIONHISTORY);
        String uniqueID = ps.getValue().getString();
        NodeId vhId = this.workspaceManager.getIdFactory().createNodeId(uniqueID);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(vhId);
    }
}

