/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.TransientOperation;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.ItemId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Remove
extends TransientOperation {
    private static Logger log = LoggerFactory.getLogger(Remove.class);
    private static final int REMOVE_OPTIONS = 14;
    private final ItemId removeId;
    protected ItemState removeState;
    protected NodeState parent;

    private Remove(ItemState removeState, NodeState parent) throws RepositoryException {
        this(removeState, parent, 14);
    }

    private Remove(ItemState removeState, NodeState parent, int options) throws RepositoryException {
        super(options);
        this.removeId = removeState.getId();
        this.removeState = removeState;
        this.parent = parent;
        this.addAffectedItemState(removeState);
        this.addAffectedItemState(parent);
    }

    @Override
    public void accept(OperationVisitor visitor) throws AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() throws RepositoryException {
        assert (this.status == 0);
        this.status = 1;
        this.parent.getHierarchyEntry().complete(this);
    }

    @Override
    public void undo() throws RepositoryException {
        assert (this.status == 0);
        this.status = 2;
        this.parent.getHierarchyEntry().complete(this);
    }

    public ItemId getRemoveId() throws RepositoryException {
        return this.removeId;
    }

    public ItemState getRemoveState() {
        return this.removeState;
    }

    public NodeState getParentState() {
        return this.parent;
    }

    public static Operation create(ItemState state) throws RepositoryException {
        if (state.isNode() && ((NodeState)state).getDefinition().allowsSameNameSiblings()) {
            Remove.assertChildNodeEntries(state.getParent());
        }
        return new Remove(state, state.getParent());
    }
}

