/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.commons.webdav.QueryUtil;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultRowImpl
implements QueryResultRow {
    private static final Logger log = LoggerFactory.getLogger(QueryResultRowImpl.class);
    private static final DavPropertyName SEARCH_RESULT_PROPERTY = DavPropertyName.create((String)"search-result-property", (Namespace)ItemResourceConstants.NAMESPACE);
    private final Map<Name, NodeId> nodeIds = new HashMap<Name, NodeId>();
    private final Map<Name, Double> scores = new HashMap<Name, Double>();
    private final Map<String, QValue> qValues = new HashMap<String, QValue>();
    private final String[] columnNames;
    private final Name[] selectorNames;

    public QueryResultRowImpl(MultiStatusResponse response, String[] columnNames, NamePathResolver resolver, QValueFactory qValueFactory, ValueFactory valueFactory, IdFactory idFactory) throws RepositoryException {
        this.columnNames = columnNames;
        DavPropertySet okSet = response.getProperties(200);
        String jcrPath = resolver.getJCRName(NameConstants.JCR_PATH);
        String jcrScore = resolver.getJCRName(NameConstants.JCR_SCORE);
        DavProperty davProp = okSet.get(SEARCH_RESULT_PROPERTY);
        ArrayList colList = new ArrayList();
        ArrayList selList = new ArrayList();
        ArrayList valList = new ArrayList();
        QueryUtil.parseResultPropertyValue((Object)davProp.getValue(), colList, selList, valList, (ValueFactory)valueFactory);
        String[] names = colList.toArray(new String[colList.size()]);
        Value[] values = valList.toArray(new Value[valList.size()]);
        this.selectorNames = new Name[selList.size()];
        for (int i = 0; i < values.length; ++i) {
            try {
                String selectorName = (String)selList.get(i);
                QValue v = values[i] == null ? null : ValueFormat.getQValue((Value)values[i], (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                Name name = this.selectorNames[i] = selectorName == null ? null : resolver.getQName(selectorName);
                if (jcrScore.equals(names[i])) {
                    Double score = 0.0;
                    if (v != null) {
                        score = v.getDouble();
                    }
                    this.scores.put(this.selectorNames[i], score);
                } else if (jcrPath.equals(names[i])) {
                    NodeId id = null;
                    if (v != null) {
                        id = idFactory.createNodeId((String)null, v.getPath());
                    }
                    this.nodeIds.put(this.selectorNames[i], id);
                }
                this.qValues.put(names[i], v);
                continue;
            }
            catch (RepositoryException e) {
                log.error("Malformed value: " + values[i].toString());
            }
        }
    }

    public NodeId getNodeId(Name selectorName) {
        NodeId id = this.nodeIds.get(selectorName);
        if (id == null) {
            if (this.nodeIds.size() == 1) {
                return this.nodeIds.values().iterator().next();
            }
            throw new IllegalArgumentException(selectorName + " is not a valid selectorName");
        }
        return id;
    }

    public double getScore(Name selectorName) {
        Double score = this.scores.get(selectorName);
        if (score == null) {
            if (this.scores.size() == 1) {
                return this.scores.values().iterator().next();
            }
            throw new IllegalArgumentException(selectorName + " is not a valid selectorName");
        }
        return score;
    }

    public QValue[] getValues() {
        QValue[] values = new QValue[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            values[i] = this.qValues.get(this.columnNames[i]);
        }
        return values;
    }

    Name[] getSelectorNames() {
        return this.selectorNames;
    }
}

